/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.tags;

import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.tags.RequestContextAwareTag;

public abstract class BaseTagSupport
extends RequestContextAwareTag {
    private static final Log log = LogFactory.getLog(BaseTagSupport.class);
    private static final Object NO_ATTRIBUTE = new Object();
    private static final String BEAN_CONFIGURATION = "configurationBean";

    protected void includeNested(String path) throws JspException {
        BodyContent nestedContent = this.pageContext.pushBody();
        boolean popped = false;
        try {
            this.pageContext.include(path);
            popped = true;
            this.pageContext.popBody();
            nestedContent.writeOut((Writer)this.pageContext.getOut());
        }
        catch (ServletException e) {
            log.error((Object)e, (Throwable)e);
            throw new JspException((Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            throw new JspException((Throwable)e);
        }
        finally {
            if (!popped) {
                this.pageContext.popBody();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void includeNested(String path, Map attributes) throws JspException {
        Map restoreAttrs = this.setRequestAttributes(attributes);
        try {
            this.includeNested(path);
        }
        finally {
            this.restoreRequestAttributes(restoreAttrs);
        }
    }

    protected Map setRequestAttributes(Map attributes) {
        ServletRequest request = this.pageContext.getRequest();
        HashSet<String> attributeNames = new HashSet<String>();
        Enumeration it = request.getAttributeNames();
        while (it.hasMoreElements()) {
            String attribute = (String)it.nextElement();
            attributeNames.add(attribute);
        }
        HashMap<String, Object> restoreMap = new HashMap<String, Object>();
        for (Map.Entry entry : attributes.entrySet()) {
            String attribute = (String)entry.getKey();
            Object value = entry.getValue();
            Object restoreValue = attributeNames.contains(attribute) ? request.getAttribute(attribute) : NO_ATTRIBUTE;
            restoreMap.put(attribute, restoreValue);
            request.setAttribute(attribute, value);
        }
        return restoreMap;
    }

    protected void restoreRequestAttributes(Map restoreMap) {
        ServletRequest request = this.pageContext.getRequest();
        for (Map.Entry entry : restoreMap.entrySet()) {
            String attribute = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == NO_ATTRIBUTE) {
                request.removeAttribute(attribute);
                continue;
            }
            request.setAttribute(attribute, value);
        }
    }

    protected ConfigurationBean getConfiguration() {
        return (ConfigurationBean)this.getRequestContext().getWebApplicationContext().getBean(BEAN_CONFIGURATION, ConfigurationBean.class);
    }
}

