/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.util;

import com.jaspersoft.jasperserver.war.util.ObjectMatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardRequestMatcher
implements ObjectMatcher<HttpServletRequest> {
    private static final Log log = LogFactory.getLog(StandardRequestMatcher.class);
    private String method;
    private String scheme;
    private Map<String, String> headers;
    private transient ThreadLocal<Map<String, Pattern>> compiledPatternCache = new ThreadLocal<Map<String, Pattern>>(){

        @Override
        protected Map<String, Pattern> initialValue() {
            return new HashMap<String, Pattern>();
        }
    };

    @Override
    public boolean matches(HttpServletRequest request) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Matching request " + request + " against " + this));
        }
        if (this.method != null && !this.matchesValue(request.getMethod(), this.method)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request method " + request.getMethod() + " does not match method " + this.method));
            }
            return false;
        }
        if (this.scheme != null && !this.matchesValue(request.getScheme(), this.scheme)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request scheme " + request.getScheme() + " does not match scheme " + this.scheme));
            }
            return false;
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            for (Map.Entry<String, String> headerEntry : this.headers.entrySet()) {
                String header = headerEntry.getKey();
                String headerPattern = headerEntry.getValue();
                String value = request.getHeader(header);
                if (this.matchesValue(value, headerPattern)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Request header " + header + ": " + value + " does not match " + headerPattern));
                }
                return false;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request " + request + " matches " + this));
        }
        return true;
    }

    protected boolean matchesValue(String value, String pattern) {
        value = value == null ? "" : value.toLowerCase();
        return this.compiledPattern(pattern).matcher(value).matches();
    }

    protected Pattern compiledPattern(String pattern) {
        Map<String, Pattern> compiledPatterns = this.compiledPatternCache.get();
        Pattern compiled = compiledPatterns.get(pattern);
        if (compiled == null) {
            compiled = Pattern.compile(pattern);
            compiledPatterns.put(pattern, compiled);
        }
        return compiled;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("method", (Object)this.method).append("scheme", (Object)this.scheme).append("headers", this.headers).toString();
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }
}

