/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.List;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.runtime.RuntimePlugin;

public abstract class RuntimeVDB {
    private VDBMetaData vdb;
    private VDBModificationListener listener;
    private boolean restartInProgress = false;

    public RuntimeVDB(VDBMetaData vdb, VDBModificationListener listener) {
        this.vdb = vdb;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataRole(String policyName, String mappedRole) throws AdminProcessingException {
        VDBMetaData vDBMetaData = this.vdb;
        synchronized (vDBMetaData) {
            DataPolicyMetadata policy = this.getPolicy(policyName);
            List previous = policy.getMappedRoleNames();
            policy.addMappedRoleName(mappedRole);
            try {
                this.listener.dataRoleChanged(policyName);
            }
            catch (AdminProcessingException e) {
                policy.setMappedRoleNames(previous);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteDataRole(String policyName, String mappedRole) throws AdminProcessingException {
        VDBMetaData vDBMetaData = this.vdb;
        synchronized (vDBMetaData) {
            DataPolicyMetadata policy = this.getPolicy(policyName);
            List previous = policy.getMappedRoleNames();
            policy.removeMappedRoleName(mappedRole);
            try {
                this.listener.dataRoleChanged(policyName);
            }
            catch (AdminProcessingException e) {
                policy.setMappedRoleNames(previous);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnyAuthenticated(String policyName) throws AdminProcessingException {
        VDBMetaData vDBMetaData = this.vdb;
        synchronized (vDBMetaData) {
            DataPolicyMetadata policy = this.getPolicy(policyName);
            boolean previous = policy.isAnyAuthenticated();
            policy.setAnyAuthenticated(true);
            try {
                this.listener.dataRoleChanged(policyName);
            }
            catch (AdminProcessingException e) {
                policy.setAnyAuthenticated(previous);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnyAuthenticated(String policyName) throws AdminProcessingException {
        VDBMetaData vDBMetaData = this.vdb;
        synchronized (vDBMetaData) {
            DataPolicyMetadata policy = this.getPolicy(policyName);
            boolean previous = policy.isAnyAuthenticated();
            policy.setAnyAuthenticated(false);
            try {
                this.listener.dataRoleChanged(policyName);
            }
            catch (AdminProcessingException e) {
                policy.setAnyAuthenticated(previous);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeConnectionType(VDB.ConnectionType type) throws AdminProcessingException {
        VDBMetaData vDBMetaData = this.vdb;
        synchronized (vDBMetaData) {
            VDB.ConnectionType previous = this.vdb.getConnectionType();
            this.vdb.setConnectionType(type);
            try {
                this.listener.connectionTypeChanged();
            }
            catch (AdminProcessingException e) {
                this.vdb.setConnectionType(previous);
                throw e;
            }
        }
    }

    public ReplaceResult assignDatasource(String modelName, String sourceName, String translatorName, String dsName) throws AdminProcessingException {
        VDBMetaData vDBMetaData = this.vdb;
        synchronized (vDBMetaData) {
            ModelMetaData model = this.vdb.getModel(modelName);
            if (model == null) {
                throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40090, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40090, new Object[]{modelName, this.vdb.getName(), this.vdb.getVersion()}));
            }
            SourceMappingMetadata source = model.getSourceMapping(sourceName);
            if (source == null) {
                throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40091, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40091, new Object[]{sourceName, modelName, this.vdb.getName(), this.vdb.getVersion()}));
            }
            String previousTranslatorName = source.getTranslatorName();
            String previousDsName = source.getConnectionJndiName();
            source.setTranslatorName(translatorName);
            source.setConnectionJndiName(dsName);
            try {
                boolean replaced;
                this.listener.dataSourceChanged(modelName, sourceName, translatorName, dsName);
                ConnectorManagerRepository cmr = (ConnectorManagerRepository)this.vdb.getAttachment(ConnectorManagerRepository.class);
                ReplaceResult rr = new ReplaceResult();
                if (dsName != null) {
                    boolean bl = rr.isNew = !this.dsExists(dsName, cmr);
                }
                if ((replaced = this.getVDBStatusChecker().dataSourceReplaced(this.vdb.getName(), this.vdb.getVersion(), modelName, sourceName, translatorName, dsName)) && previousDsName != null && !this.dsExists(previousDsName, cmr)) {
                    rr.removedDs = previousDsName;
                }
                return rr;
            }
            catch (AdminProcessingException e) {
                source.setTranslatorName(previousTranslatorName);
                source.setConnectionJndiName(previousDsName);
                throw e;
            }
        }
    }

    private boolean dsExists(String dsName, ConnectorManagerRepository cmr) {
        String baseDsName = VDBStatusChecker.stripContext(dsName);
        for (ConnectorManager cm : cmr.getConnectorManagers().values()) {
            if (!baseDsName.equals(VDBStatusChecker.stripContext(cm.getConnectionName()))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(List<String> modelNames) throws AdminProcessingException {
        VDBMetaData vDBMetaData = this.vdb;
        synchronized (vDBMetaData) {
            this.restartInProgress = true;
            this.listener.onRestart(modelNames);
        }
    }

    private DataPolicyMetadata getPolicy(String policyName) throws AdminProcessingException {
        DataPolicyMetadata policy = this.vdb.getDataPolicy(policyName);
        if (policy == null) {
            throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40092, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40092, new Object[]{policyName, this.vdb.getName(), this.vdb.getVersion()}));
        }
        return policy;
    }

    public boolean isRestartInProgress() {
        return this.restartInProgress;
    }

    public VDBMetaData getVdb() {
        return this.vdb;
    }

    protected abstract VDBStatusChecker getVDBStatusChecker();

    public static interface VDBModificationListener {
        public void dataRoleChanged(String var1) throws AdminProcessingException;

        public void connectionTypeChanged() throws AdminProcessingException;

        public void dataSourceChanged(String var1, String var2, String var3, String var4) throws AdminProcessingException;

        public void onRestart(List<String> var1) throws AdminProcessingException;
    }

    public static class ReplaceResult {
        public boolean isNew;
        public String removedDs;
    }
}

