/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.data.DataAdapterServiceUtil;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.ParameterContributor;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.ParameterContributorFactory;
import net.sf.jasperreports.repo.RepositoryUtil;

public final class DataAdapterParameterContributorFactory
implements ParameterContributorFactory {
    public static final String PROPERTY_DATA_ADAPTER_LOCATION = "net.sf.jasperreports.data.adapter";
    private static final DataAdapterParameterContributorFactory INSTANCE = new DataAdapterParameterContributorFactory();

    private DataAdapterParameterContributorFactory() {
    }

    public static DataAdapterParameterContributorFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public List<ParameterContributor> getContributors(ParameterContributorContext context) throws JRException {
        ArrayList<ParameterContributor> contributors = new ArrayList<ParameterContributor>();
        String dataAdapterUri = JRPropertiesUtil.getInstance(context.getJasperReportsContext()).getProperty(context.getDataset(), PROPERTY_DATA_ADAPTER_LOCATION);
        if (dataAdapterUri != null) {
            DataAdapter dataAdapter = RepositoryUtil.getInstance(context.getJasperReportsContext()).getResourceFromLocation(dataAdapterUri, DataAdapter.class);
            DataAdapterService dataAdapterService = DataAdapterServiceUtil.getInstance(context.getJasperReportsContext()).getService(dataAdapter);
            return Collections.singletonList(dataAdapterService);
        }
        return contributors;
    }
}

