/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.analytics.dataset;

import net.sf.jasperreports.engine.analytics.data.Axis;
import net.sf.jasperreports.engine.analytics.dataset.BaseDataAxis;
import net.sf.jasperreports.engine.analytics.dataset.DataAxisLevel;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;

public class DesignDataAxis
extends BaseDataAxis
implements JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_AXIS = "axis";
    public static final String PROPERTY_LEVELS = "levels";
    private transient JRPropertyChangeSupport eventSupport;

    public void setAxis(Axis axis) {
        Axis old = this.axis;
        this.axis = axis;
        this.getEventSupport().firePropertyChange(PROPERTY_AXIS, old, this.axis);
    }

    public void addLevel(DataAxisLevel level) {
        this.levels.add(level);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_LEVELS, level, this.levels.size() - 1);
    }

    public void removeLevel(DataAxisLevel level) {
        int idx = this.levels.indexOf(level);
        if (idx >= 0) {
            this.levels.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_LEVELS, this.levels, idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        DesignDataAxis designDataAxis = this;
        synchronized (designDataAxis) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

