/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlUtil {
    public static final char CR_CHAR = '\r';
    public static final char NL_CHAR = '\n';
    public static final char SPACE_CHAR = ' ';
    public static final char TAB_CHAR = '\t';
    private static TreeSet<String> updateKeywords = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    private static Pattern PATTERN;
    private static Pattern INTO_PATTERN;

    private SqlUtil() {
    }

    public static boolean isUpdateSql(String sql) throws IllegalArgumentException {
        String keyWord = SqlUtil.getKeyword(sql);
        return updateKeywords.contains(keyWord);
    }

    public static String getKeyword(String sql) {
        Matcher matcher = PATTERN.matcher(sql);
        if (!matcher.find()) {
            return sql;
        }
        String keyword = matcher.group(1);
        if (keyword.equalsIgnoreCase("select")) {
            int end = matcher.end();
            Matcher intoMatcher = INTO_PATTERN.matcher(sql);
            while (intoMatcher.find(end)) {
                if (intoMatcher.group(1) != null) {
                    return "insert";
                }
                end = intoMatcher.end();
            }
        }
        return keyword;
    }

    public static SQLException createFeatureNotSupportedException() {
        StackTraceElement ste = new Exception().getStackTrace()[1];
        String methodName = ste.getMethodName();
        return new SQLFeatureNotSupportedException(methodName + " is not supported");
    }

    static {
        updateKeywords.add("insert");
        updateKeywords.add("update");
        updateKeywords.add("delete");
        updateKeywords.add("drop");
        updateKeywords.add("create");
        PATTERN = Pattern.compile("^(?:\\s|(?:/\\*.*\\*/))*(\\w*)\\s", 34);
        INTO_PATTERN = Pattern.compile("(?:'[^']*')|(\\sinto\\s)", 34);
    }
}

