/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.core.util;

import com.jaspersoft.jasperserver.core.util.MissingObject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.log4j.Logger;

public class TolerantObjectWrapper
implements Serializable {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected Object obj;

    public TolerantObjectWrapper(Object obj) {
        this.obj = obj;
    }

    public Object getObject() {
        return this.obj;
    }

    public void setObject(Object obj) {
        this.obj = obj;
    }

    public String toString() {
        return this.obj.getClass().toString();
    }

    private boolean testIsSerializable(Object obj) throws IOException {
        NullOutputStream nos = new NullOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream((OutputStream)nos);
            oos.writeObject(obj);
            oos.close();
            nos.close();
        }
        catch (Exception err) {
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.obj = stream.readObject();
    }

    private void writeObject(ObjectOutputStream stream) throws ClassNotFoundException, IOException {
        if (this.testIsSerializable(this.obj)) {
            stream.writeObject(this.obj);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Non serialized object on session " + this.obj.getClass()));
            }
            stream.writeObject(new MissingObject("MissingValue"));
        }
    }
}

