/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.core.BundleUtil;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.jboss.BaseCachehandler;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.logging.LogManager;

class ClearCache
extends BaseCachehandler {
    protected ClearCache() {
        super("clear-cache");
    }

    @Override
    protected void executeOperation(OperationContext context, SessionAwareCache cache, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("cache-type")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("cache-type.missing")));
        }
        String cacheType = operation.get("cache-type").asString();
        if (cache == null) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50071, new Object[]{cacheType})));
        }
        if (operation.hasDefined("vdb-name") && operation.hasDefined("vdb-version")) {
            int vdbVersion;
            String vdbName = operation.get("vdb-name").asString();
            if (!this.isValidVDB(context, vdbName, vdbVersion = operation.get("vdb-version").asInt())) {
                throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50096, new Object[]{vdbName, vdbVersion})));
            }
            LogManager.logInfo((String)"org.teiid.PROCESSOR", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50005, new Object[]{cacheType, vdbName, vdbVersion}));
            cache.clearForVDB(vdbName, vdbVersion);
        } else {
            LogManager.logInfo((String)"org.teiid.PROCESSOR", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50005, new Object[]{cacheType}));
            cache.clearAll();
        }
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        operationNode.get(new String[]{"request-properties", "cache-type", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "cache-type", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "cache-type", "description"}).set(this.getParameterDescription(bundle, "cache-type"));
        operationNode.get(new String[]{"request-properties", "vdb-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "vdb-name", "required"}).set(false);
        operationNode.get(new String[]{"request-properties", "vdb-name", "description"}).set(this.getParameterDescription(bundle, "vdb-name"));
        operationNode.get(new String[]{"request-properties", "vdb-version", "type"}).set(ModelType.INT);
        operationNode.get(new String[]{"request-properties", "vdb-version", "required"}).set(false);
        operationNode.get(new String[]{"request-properties", "vdb-version", "description"}).set(this.getParameterDescription(bundle, "vdb-version"));
        operationNode.get("reply-properties").setEmptyObject();
    }
}

