/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataMapper;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.jboss.BaseOperationHandler;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidServiceNames;

class GetVDB
extends BaseOperationHandler<VDBRepository> {
    protected GetVDB() {
        super("get-vdb");
    }

    @Override
    protected VDBRepository getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        ServiceController sc = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.VDB_REPO);
        return (VDBRepository)VDBRepository.class.cast(sc.getValue());
    }

    @Override
    protected void executeOperation(OperationContext context, VDBRepository repo, ModelNode operation) throws OperationFailedException {
        int vdbVersion;
        if (!operation.hasDefined("vdb-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("vdb-name.missing")));
        }
        if (!operation.hasDefined("vdb-version")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("vdb-version.missing")));
        }
        ModelNode result = context.getResult();
        String vdbName = operation.get("vdb-name").asString();
        VDBMetaData vdb = repo.getVDB(vdbName, vdbVersion = operation.get("vdb-version").asInt());
        if (vdb == null) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50096, new Object[]{vdbName, vdbVersion})));
        }
        VDBMetadataMapper.INSTANCE.wrap(vdb, result);
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        operationNode.get(new String[]{"request-properties", "vdb-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "vdb-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "vdb-name", "description"}).set(this.getParameterDescription(bundle, "vdb-name"));
        operationNode.get(new String[]{"request-properties", "vdb-version", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "vdb-version", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "vdb-version", "description"}).set(this.getParameterDescription(bundle, "vdb-version"));
        ModelNode reply = operationNode.get("reply-properties");
        reply.get("type").set(ModelType.OBJECT);
        VDBMetadataMapper.INSTANCE.describe(reply.get("value-type"));
    }
}

