/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.CacheException;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferLockReacquisitionException;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferLockImpl
implements StateTransferLock {
    private static final Log log = LogFactory.getLog(StateTransferLockImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private AtomicInteger runningWritesCount = new AtomicInteger(0);
    private volatile boolean writesShouldBlock;
    private volatile boolean writesBlocked;
    private final ThreadLocal<Boolean> traceThreadWrites = new ThreadLocal();
    private int blockingCacheViewId = -1;
    private final Object lock = new Object();
    private boolean pessimisticLocking;
    private long lockTimeout;
    private boolean isSync;

    @Inject
    public void injectDependencies(Configuration config) {
        this.pessimisticLocking = config.getTransactionLockingMode() == LockingMode.PESSIMISTIC;
        this.isSync = config.getCacheMode().isSynchronous();
        this.lockTimeout = config.getRehashWaitTime();
    }

    @Override
    public void releaseForCommand(InvocationContext ctx, WriteCommand command) {
        if (this.shouldAcquireLock(ctx, command)) {
            this.releaseLockForWrite();
        }
    }

    @Override
    public void releaseForCommand(TxInvocationContext ctx, PrepareCommand command) {
        if (this.shouldAcquireLock(ctx, command)) {
            this.releaseLockForWrite();
        }
    }

    @Override
    public void releaseForCommand(TxInvocationContext ctx, CommitCommand command) {
        if (this.shouldAcquireLock(ctx, command)) {
            this.releaseLockForWrite();
        }
    }

    @Override
    public void releaseForCommand(TxInvocationContext ctx, RollbackCommand command) {
    }

    @Override
    public void releaseForCommand(TxInvocationContext ctx, LockControlCommand command) {
        if (this.shouldAcquireLock(ctx, command)) {
            this.releaseLockForWrite();
        }
    }

    @Override
    public boolean acquireForCommand(InvocationContext ctx, WriteCommand command) throws InterruptedException, TimeoutException {
        if (!this.shouldAcquireLock(ctx, command)) {
            return true;
        }
        return this.acquireLockForWriteCommand(ctx);
    }

    @Override
    public boolean acquireForCommand(TxInvocationContext ctx, PrepareCommand command) throws InterruptedException, TimeoutException {
        if (!this.shouldAcquireLock(ctx, command)) {
            return true;
        }
        return this.acquireLockForWriteCommand(ctx);
    }

    @Override
    public boolean acquireForCommand(TxInvocationContext ctx, CommitCommand command) throws InterruptedException, TimeoutException {
        if (!this.shouldAcquireLock(ctx, command)) {
            return true;
        }
        return this.acquireLockForCommitCommand(ctx);
    }

    @Override
    public boolean acquireForCommand(TxInvocationContext ctx, RollbackCommand command) throws InterruptedException, TimeoutException {
        return true;
    }

    @Override
    public boolean acquireForCommand(TxInvocationContext ctx, LockControlCommand command) throws TimeoutException, InterruptedException {
        if (!this.shouldAcquireLock(ctx, command)) {
            return true;
        }
        return this.acquireLockForWriteCommand(ctx);
    }

    private boolean shouldAcquireLock(InvocationContext ctx, WriteCommand command) {
        return (!ctx.isInTxScope() || this.pessimisticLocking) && !ctx.hasFlag(Flag.SKIP_LOCKING);
    }

    private boolean shouldAcquireLock(TxInvocationContext ctx, PrepareCommand command) {
        return !ctx.hasFlag(Flag.SKIP_LOCKING);
    }

    private boolean shouldAcquireLock(TxInvocationContext ctx, CommitCommand command) {
        return !ctx.hasFlag(Flag.SKIP_LOCKING);
    }

    private boolean shouldAcquireLock(TxInvocationContext ctx, RollbackCommand command) {
        return false;
    }

    private boolean shouldAcquireLock(TxInvocationContext ctx, LockControlCommand command) {
        return !command.isUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForStateTransferToEnd(InvocationContext ctx, VisitableCommand command, int newCacheViewId) throws TimeoutException, InterruptedException {
        boolean shouldSuspendLock;
        if (!this.writesShouldBlock && newCacheViewId <= this.blockingCacheViewId) {
            return;
        }
        try {
            shouldSuspendLock = (Boolean)command.acceptVisitor(ctx, new ShouldAcquireLockVisitor());
        }
        catch (Throwable throwable) {
            throw new CacheException("Unexpected exception", throwable);
        }
        if (shouldSuspendLock) {
            log.tracef("Suspending shared state transfer lock to allow state transfer to start (and end)", new Object[0]);
            this.releaseLockForWrite();
            long end = Util.currentMillisFromNanotime() + this.lockTimeout;
            long timeout = this.lockTimeout;
            Object object = this.lock;
            synchronized (object) {
                while (timeout > 0L && this.blockingCacheViewId < newCacheViewId) {
                    if (trace) {
                        log.tracef("We are waiting for cache view %d, right now we have %d", newCacheViewId, this.blockingCacheViewId);
                    }
                    this.lock.wait(timeout);
                    timeout = end - Util.currentMillisFromNanotime();
                }
            }
            if (timeout <= 0L || !this.acquireLockForWriteCommand(ctx)) {
                throw new StateTransferLockReacquisitionException("We released the state transfer lock temporarily but we cannot acquire it back");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockNewTransactions(int cacheViewId) throws InterruptedException {
        log.debugf("Blocking new write commands for cache view %d", cacheViewId);
        Object object = this.lock;
        synchronized (object) {
            this.writesShouldBlock = true;
            if (this.writesBlocked) {
                if (this.blockingCacheViewId < cacheViewId) {
                    log.tracef("Write commands were already blocked for cache view %d", this.blockingCacheViewId);
                } else {
                    throw new IllegalStateException(String.format("Trying to block write commands but they are already blocked for view %d", this.blockingCacheViewId));
                }
            }
            while (this.runningWritesCount.get() != 0) {
                this.lock.wait();
            }
            this.writesBlocked = true;
            this.blockingCacheViewId = cacheViewId;
        }
        log.tracef("New write commands blocked", new Object[0]);
    }

    @Override
    public void blockNewTransactionsAsync() {
        if (!this.writesShouldBlock) {
            log.debugf("Blocking new write commands because we'll soon start a state transfer", new Object[0]);
            this.writesShouldBlock = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unblockNewTransactions(int cacheViewId) {
        log.debugf("Unblocking write commands for cache view %d", cacheViewId);
        Object object = this.lock;
        synchronized (object) {
            boolean writesWereBlocked = this.writesBlocked;
            this.writesShouldBlock = false;
            this.writesBlocked = false;
            this.lock.notifyAll();
            if (!writesWereBlocked) {
                throw new IllegalStateException(String.format("Trying to unblock write commands for cache view %d but they were not blocked", cacheViewId));
            }
            if (cacheViewId != this.blockingCacheViewId && this.blockingCacheViewId != -1) {
                throw new IllegalStateException(String.format("Trying to unblock write commands for cache view %d, but they were blocked with view id %d", cacheViewId, this.blockingCacheViewId));
            }
        }
        log.tracef("Unblocked write commands for cache view %d", cacheViewId);
    }

    @Override
    public boolean areNewTransactionsBlocked() {
        return this.writesShouldBlock;
    }

    @Override
    public int getBlockingCacheViewId() {
        return this.blockingCacheViewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireLockForWriteCommand(InvocationContext ctx) throws InterruptedException, TimeoutException {
        if (this.acquireLockForWriteNoWait()) {
            return true;
        }
        if (!ctx.isOriginLocal() && this.isSync) {
            return false;
        }
        long timeout = this.lockTimeout;
        long endTime = Util.currentMillisFromNanotime() + this.lockTimeout;
        Object object = this.lock;
        synchronized (object) {
            do {
                if (this.acquireLockForWriteNoWait()) {
                    return true;
                }
                this.lock.wait(timeout);
            } while ((timeout = endTime - Util.currentMillisFromNanotime()) > 0L);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireLockForWriteNoWait() {
        if (!this.writesShouldBlock) {
            int previousWrites = this.runningWritesCount.getAndIncrement();
            if (previousWrites > 0 || !this.writesShouldBlock) {
                if (trace) {
                    if (this.traceThreadWrites.get() == Boolean.TRUE) {
                        log.error("Trying to acquire state transfer shared lock, but this thread already has it", new Exception());
                    }
                    this.traceThreadWrites.set(Boolean.TRUE);
                    log.tracef("Acquired shared state transfer shared lock, total holders: %d", this.runningWritesCount.get());
                }
                return true;
            }
            this.runningWritesCount.decrementAndGet();
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
        return false;
    }

    private boolean acquireLockForCommitCommand(InvocationContext ctx) throws InterruptedException, TimeoutException {
        if (this.acquireLockForCommitNoWait()) {
            return true;
        }
        if (!ctx.isOriginLocal() && this.isSync) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (this.acquireLockForCommitNoWait()) {
                    return true;
                }
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireLockForCommitNoWait() {
        if (!this.writesBlocked) {
            int previousWrites = this.runningWritesCount.getAndIncrement();
            if (previousWrites > 0 || !this.writesBlocked) {
                if (trace) {
                    if (this.traceThreadWrites.get() == Boolean.TRUE) {
                        log.error("Trying to acquire state transfer shared lock, but this thread already has it", new Exception());
                    }
                    this.traceThreadWrites.set(Boolean.TRUE);
                    log.tracef("Acquired shared state transfer shared lock (for commit), total holders: %d", this.runningWritesCount.get());
                }
                return true;
            }
            this.runningWritesCount.decrementAndGet();
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLockForWrite() {
        int remainingWrites;
        if (trace) {
            if (this.traceThreadWrites.get() != Boolean.TRUE) {
                log.error("Trying to release state transfer shared lock without acquiring it first", new Exception());
            }
            this.traceThreadWrites.remove();
        }
        if ((remainingWrites = this.runningWritesCount.decrementAndGet()) < 0) {
            this.runningWritesCount.incrementAndGet();
            log.error("Trying to release state transfer shared lock without acquiring it first", new Exception());
        } else if (remainingWrites == 0 && this.writesShouldBlock) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
        if (trace) {
            log.tracef("Released shared state transfer shared lock, remaining holders: %d", remainingWrites);
        }
    }

    public String toString() {
        return "StateTransferLockImpl{runningWritesCount=" + this.runningWritesCount + ", writesShouldBlock=" + this.writesShouldBlock + ", writesBlocked=" + this.writesBlocked + ", blockingCacheViewId=" + this.blockingCacheViewId + '}';
    }

    private class ShouldAcquireLockVisitor
    extends AbstractVisitor {
        private ShouldAcquireLockVisitor() {
        }

        @Override
        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            return StateTransferLockImpl.this.shouldAcquireLock(ctx, command);
        }

        @Override
        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            return Boolean.FALSE;
        }
    }
}

