/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.statistics.sampled;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.statistics.CacheUsageListener;
import net.sf.ehcache.statistics.sampled.CacheStatisticsSampler;
import net.sf.ehcache.util.FailSafeTimer;
import net.sf.ehcache.util.counter.CounterConfig;
import net.sf.ehcache.util.counter.CounterManager;
import net.sf.ehcache.util.counter.CounterManagerImpl;
import net.sf.ehcache.util.counter.sampled.SampledCounter;
import net.sf.ehcache.util.counter.sampled.SampledCounterConfig;
import net.sf.ehcache.util.counter.sampled.SampledRateCounter;
import net.sf.ehcache.util.counter.sampled.SampledRateCounterConfig;
import net.sf.ehcache.util.counter.sampled.SampledRateCounterImpl;

public class SampledCacheStatisticsImpl
implements CacheUsageListener,
CacheStatisticsSampler {
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int HIT_RATIO_MULTIPLIER = 100;
    private static final SampledCounterConfig DEFAULT_SAMPLED_COUNTER_CONFIG = new SampledCounterConfig(1, 30, true, 0L);
    private static final SampledRateCounterConfig DEFAULT_RATE_COUNTER_CONFIG = new SampledRateCounterConfig(1, 30, true);
    private static final SampledRateCounterConfig DEFAULT_AVG_SEARCH_COUNTER_CONFIG = new SampledRateCounterConfig(10, 30, true);
    private volatile CounterManager counterManager;
    private final SampledCounter cacheHitCount;
    private final SampledCounter cacheHitInMemoryCount;
    private final SampledCounter cacheHitOffHeapCount;
    private final SampledCounter cacheHitOnDiskCount;
    private final SampledCounter cacheMissCount;
    private final SampledCounter cacheMissInMemoryCount;
    private final SampledCounter cacheMissOffHeapCount;
    private final SampledCounter cacheMissOnDiskCount;
    private final SampledCounter cacheMissExpiredCount;
    private final SampledCounter cacheMissNotFoundCount;
    private final SampledCounter cacheHitRatio;
    private final SampledCounter cacheElementEvictedCount;
    private final SampledCounter cacheElementRemoved;
    private final SampledCounter cacheElementExpired;
    private final SampledCounter cacheElementPut;
    private final SampledCounter cacheElementUpdated;
    private final SampledCounter cacheSearchCount;
    private final SampledCounter cacheXaCommitCount;
    private final SampledCounter cacheXaRollbackCount;
    private final SampledRateCounter averageGetTime;
    private final SampledRateCounter averageGetTimeNanos;
    private final SampledRateCounter averageSearchTime;
    private final AtomicBoolean sampledStatisticsEnabled;
    private final AtomicInteger statisticsAccuracy;

    public SampledCacheStatisticsImpl(FailSafeTimer timer) {
        this(timer, DEFAULT_SAMPLED_COUNTER_CONFIG, DEFAULT_RATE_COUNTER_CONFIG, DEFAULT_AVG_SEARCH_COUNTER_CONFIG);
    }

    public SampledCacheStatisticsImpl(FailSafeTimer timer, SampledCounterConfig config) {
        this(timer, config, DEFAULT_RATE_COUNTER_CONFIG, DEFAULT_AVG_SEARCH_COUNTER_CONFIG);
    }

    public SampledCacheStatisticsImpl(FailSafeTimer timer, SampledCounterConfig config, SampledRateCounterConfig rateGetConfig, SampledRateCounterConfig rateSearchConfig) {
        this.counterManager = new CounterManagerImpl(timer);
        this.cacheHitCount = this.createSampledCounter(config);
        this.cacheHitInMemoryCount = this.createSampledCounter(config);
        this.cacheHitOffHeapCount = this.createSampledCounter(config);
        this.cacheHitOnDiskCount = this.createSampledCounter(config);
        this.cacheMissCount = this.createSampledCounter(config);
        this.cacheMissInMemoryCount = this.createSampledCounter(config);
        this.cacheMissOffHeapCount = this.createSampledCounter(config);
        this.cacheMissOnDiskCount = this.createSampledCounter(config);
        this.cacheMissExpiredCount = this.createSampledCounter(config);
        this.cacheMissNotFoundCount = this.createSampledCounter(config);
        this.cacheElementEvictedCount = this.createSampledCounter(config);
        this.cacheElementRemoved = this.createSampledCounter(config);
        this.cacheElementExpired = this.createSampledCounter(config);
        this.cacheElementPut = this.createSampledCounter(config);
        this.cacheElementUpdated = this.createSampledCounter(config);
        this.cacheSearchCount = this.createSampledCounter(config);
        this.cacheXaCommitCount = this.createSampledCounter(config);
        this.cacheXaRollbackCount = this.createSampledCounter(config);
        this.averageGetTime = (SampledRateCounter)this.createSampledCounter(rateGetConfig);
        this.averageGetTimeNanos = (SampledRateCounter)this.createSampledCounter(rateGetConfig);
        this.averageSearchTime = (SampledRateCounter)this.createSampledCounter(rateSearchConfig);
        this.cacheHitRatio = this.createCacheHitRatio(rateGetConfig);
        this.sampledStatisticsEnabled = new AtomicBoolean(true);
        this.statisticsAccuracy = new AtomicInteger(1);
    }

    private SampledCounter createCacheHitRatio(SampledRateCounterConfig rateGetConfig) {
        SampledRateCounterImpl result = new SampledRateCounterImpl(rateGetConfig){

            @Override
            public synchronized long getValue() {
                long hits = SampledCacheStatisticsImpl.this.cacheHitCount.getMostRecentSample().getCounterValue();
                long accesses = hits + SampledCacheStatisticsImpl.this.cacheMissCount.getMostRecentSample().getCounterValue();
                return (int)(accesses == 0L ? 0.0 : (double)hits / (double)accesses * 100.0);
            }
        };
        this.counterManager.addCounter(result);
        return result;
    }

    private SampledCounter createSampledCounter(CounterConfig defaultCounterConfig) {
        return (SampledCounter)this.counterManager.createCounter(defaultCounterConfig);
    }

    private void incrementIfStatsEnabled(SampledCounter ... counters) {
        if (!this.sampledStatisticsEnabled.get()) {
            return;
        }
        for (SampledCounter counter : counters) {
            counter.increment();
        }
    }

    @Override
    public void clearStatistics() {
        this.cacheHitCount.getAndReset();
        this.cacheHitInMemoryCount.getAndReset();
        this.cacheHitOffHeapCount.getAndReset();
        this.cacheHitOnDiskCount.getAndReset();
        this.cacheMissCount.getAndReset();
        this.cacheMissInMemoryCount.getAndReset();
        this.cacheMissOffHeapCount.getAndReset();
        this.cacheMissOnDiskCount.getAndReset();
        this.cacheMissExpiredCount.getAndReset();
        this.cacheMissNotFoundCount.getAndReset();
        this.cacheHitRatio.getAndReset();
        this.cacheElementEvictedCount.getAndReset();
        this.cacheElementRemoved.getAndReset();
        this.cacheElementExpired.getAndReset();
        this.cacheElementPut.getAndReset();
        this.cacheElementUpdated.getAndReset();
        this.cacheSearchCount.getAndReset();
        this.cacheXaCommitCount.getAndReset();
        this.cacheXaRollbackCount.getAndReset();
        this.averageGetTime.getAndReset();
        this.averageGetTimeNanos.getAndReset();
        this.averageSearchTime.getAndReset();
    }

    @Override
    public void notifyCacheElementEvicted() {
        this.incrementIfStatsEnabled(this.cacheElementEvictedCount);
    }

    @Override
    public void notifyCacheHitInMemory() {
        this.incrementIfStatsEnabled(this.cacheHitCount, this.cacheHitInMemoryCount);
    }

    @Override
    public void notifyCacheHitOffHeap() {
        this.incrementIfStatsEnabled(this.cacheHitCount, this.cacheHitOffHeapCount);
    }

    @Override
    public void notifyCacheHitOnDisk() {
        this.incrementIfStatsEnabled(this.cacheHitCount, this.cacheHitOnDiskCount);
    }

    @Override
    public void notifyCacheMissedWithExpired() {
        this.incrementIfStatsEnabled(this.cacheMissCount, this.cacheMissExpiredCount);
    }

    @Override
    public void notifyCacheMissedWithNotFound() {
        this.incrementIfStatsEnabled(this.cacheMissCount, this.cacheMissNotFoundCount);
    }

    @Override
    public void notifyCacheMissInMemory() {
        this.incrementIfStatsEnabled(this.cacheMissCount, this.cacheMissInMemoryCount);
    }

    @Override
    public void notifyCacheMissOffHeap() {
        this.incrementIfStatsEnabled(this.cacheMissCount, this.cacheMissOffHeapCount);
    }

    @Override
    public void notifyCacheMissOnDisk() {
        this.incrementIfStatsEnabled(this.cacheMissCount, this.cacheMissOnDiskCount);
    }

    @Override
    public void dispose() {
        this.counterManager.shutdown();
    }

    @Override
    public void notifyCacheElementExpired() {
        this.incrementIfStatsEnabled(this.cacheElementExpired);
    }

    @Override
    public void notifyCacheElementPut() throws CacheException {
        this.incrementIfStatsEnabled(this.cacheElementPut);
    }

    @Override
    public void notifyCacheElementRemoved() throws CacheException {
        this.incrementIfStatsEnabled(this.cacheElementRemoved);
    }

    @Override
    public void notifyCacheElementUpdated() throws CacheException {
        this.incrementIfStatsEnabled(this.cacheElementUpdated);
    }

    @Override
    public void notifyTimeTakenForGet(long millis) {
    }

    @Override
    public void notifyGetTimeNanos(long nanos) {
        if (!this.sampledStatisticsEnabled.get()) {
            return;
        }
        this.averageGetTimeNanos.increment(nanos, 1L);
        this.averageGetTime.increment(nanos / 1000000L, 1L);
    }

    @Override
    public void notifyRemoveAll() {
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        throw new CloneNotSupportedException();
    }

    @Override
    public void notifyStatisticsEnabledChanged(boolean enableStatistics) {
        if (!enableStatistics) {
            this.sampledStatisticsEnabled.set(false);
        }
    }

    @Override
    public void notifyStatisticsAccuracyChanged(int statisticsAccuracyValue) {
        if (Statistics.isValidStatisticsAccuracy(statisticsAccuracyValue)) {
            this.statisticsAccuracy.set(statisticsAccuracyValue);
            return;
        }
        throw new IllegalArgumentException("Invalid statistics accuracy value: " + statisticsAccuracyValue);
    }

    @Override
    public void notifyStatisticsCleared() {
        this.cacheHitCount.getAndReset();
        this.cacheHitInMemoryCount.getAndReset();
        this.cacheHitOffHeapCount.getAndReset();
        this.cacheHitOnDiskCount.getAndReset();
        this.cacheMissCount.getAndReset();
        this.cacheMissInMemoryCount.getAndReset();
        this.cacheMissOffHeapCount.getAndReset();
        this.cacheMissOnDiskCount.getAndReset();
        this.cacheMissExpiredCount.getAndReset();
        this.cacheMissNotFoundCount.getAndReset();
        this.cacheHitRatio.getAndReset();
        this.cacheElementEvictedCount.getAndReset();
        this.cacheElementRemoved.getAndReset();
        this.cacheElementExpired.getAndReset();
        this.cacheElementPut.getAndReset();
        this.cacheElementUpdated.getAndReset();
        this.cacheXaCommitCount.getAndReset();
        this.cacheXaRollbackCount.getAndReset();
        this.averageGetTime.getAndReset();
        this.averageGetTimeNanos.getAndReset();
    }

    @Override
    public long getCacheHitMostRecentSample() {
        return this.cacheHitCount.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getAverageGetTimeMostRecentSample() {
        return this.averageGetTime.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getAverageGetTimeNanosMostRecentSample() {
        return this.averageGetTimeNanos.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getCacheElementEvictedMostRecentSample() {
        return this.cacheElementEvictedCount.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getCacheHitInMemoryMostRecentSample() {
        return this.cacheHitInMemoryCount.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getCacheHitOffHeapMostRecentSample() {
        return this.cacheHitOffHeapCount.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getCacheHitOnDiskMostRecentSample() {
        return this.cacheHitOnDiskCount.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getCacheMissExpiredMostRecentSample() {
        return this.cacheMissExpiredCount.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getCacheMissMostRecentSample() {
        return this.cacheMissCount.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getCacheMissInMemoryMostRecentSample() {
        return this.cacheMissInMemoryCount.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getCacheMissOffHeapMostRecentSample() {
        return this.cacheMissOffHeapCount.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getCacheMissOnDiskMostRecentSample() {
        return this.cacheMissOnDiskCount.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getCacheMissNotFoundMostRecentSample() {
        return this.cacheMissNotFoundCount.getMostRecentSample().getCounterValue();
    }

    @Override
    public int getCacheHitRatioMostRecentSample() {
        return (int)this.cacheHitRatio.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getCacheElementExpiredMostRecentSample() {
        return this.cacheElementExpired.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getCacheElementPutMostRecentSample() {
        return this.cacheElementPut.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getCacheElementRemovedMostRecentSample() {
        return this.cacheElementRemoved.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getCacheElementUpdatedMostRecentSample() {
        return this.cacheElementUpdated.getMostRecentSample().getCounterValue();
    }

    @Override
    public int getStatisticsAccuracy() {
        return this.statisticsAccuracy.get();
    }

    @Override
    public SampledCounter getCacheHitSample() {
        return this.cacheHitCount;
    }

    @Override
    public SampledCounter getCacheHitInMemorySample() {
        return this.cacheHitInMemoryCount;
    }

    @Override
    public SampledCounter getCacheHitOffHeapSample() {
        return this.cacheHitOffHeapCount;
    }

    @Override
    public SampledCounter getCacheHitOnDiskSample() {
        return this.cacheHitOnDiskCount;
    }

    @Override
    public SampledCounter getCacheMissSample() {
        return this.cacheMissCount;
    }

    @Override
    public SampledCounter getCacheMissInMemorySample() {
        return this.cacheMissInMemoryCount;
    }

    @Override
    public SampledCounter getCacheMissOffHeapSample() {
        return this.cacheMissOffHeapCount;
    }

    @Override
    public SampledCounter getCacheMissOnDiskSample() {
        return this.cacheMissOnDiskCount;
    }

    @Override
    public SampledCounter getCacheMissExpiredSample() {
        return this.cacheMissExpiredCount;
    }

    @Override
    public SampledCounter getCacheMissNotFoundSample() {
        return this.cacheMissNotFoundCount;
    }

    @Override
    public SampledCounter getCacheHitRatioSample() {
        return this.cacheHitRatio;
    }

    @Override
    public SampledCounter getCacheElementEvictedSample() {
        return this.cacheElementEvictedCount;
    }

    @Override
    public SampledCounter getCacheElementRemovedSample() {
        return this.cacheElementRemoved;
    }

    @Override
    public SampledCounter getCacheElementExpiredSample() {
        return this.cacheElementExpired;
    }

    @Override
    public SampledCounter getCacheElementPutSample() {
        return this.cacheElementPut;
    }

    @Override
    public SampledCounter getCacheElementUpdatedSample() {
        return this.cacheElementUpdated;
    }

    @Override
    public SampledRateCounter getAverageGetTimeSample() {
        return this.averageGetTime;
    }

    @Override
    public SampledRateCounter getAverageGetTimeNanosSample() {
        return this.averageGetTimeNanos;
    }

    @Override
    public SampledRateCounter getAverageSearchTimeSample() {
        return this.averageSearchTime;
    }

    @Override
    public SampledCounter getSearchesPerSecondSample() {
        return this.cacheSearchCount;
    }

    @Override
    public String getStatisticsAccuracyDescription() {
        int value = this.statisticsAccuracy.get();
        if (value == 0) {
            return "None";
        }
        if (value == 1) {
            return "Best Effort";
        }
        return "Guaranteed";
    }

    @Override
    public boolean isSampledStatisticsEnabled() {
        return this.sampledStatisticsEnabled.get();
    }

    @Override
    public long getAverageSearchTime() {
        return this.averageSearchTime.getMostRecentSample().getCounterValue();
    }

    @Override
    public long getSearchesPerSecond() {
        return this.cacheSearchCount.getMostRecentSample().getCounterValue();
    }

    @Override
    public SampledCounter getCacheXaCommitsSample() {
        return this.cacheXaCommitCount;
    }

    @Override
    public SampledCounter getCacheXaRollbacksSample() {
        return this.cacheXaRollbackCount;
    }

    @Override
    public void notifyCacheSearch(long executeTime) {
        this.cacheSearchCount.increment();
        this.averageSearchTime.increment(executeTime, 1L);
    }

    @Override
    public long getCacheXaCommitsMostRecentSample() {
        return this.cacheXaCommitCount.getMostRecentSample().getCounterValue();
    }

    @Override
    public void notifyXaCommit() {
        this.incrementIfStatsEnabled(this.cacheXaCommitCount);
    }

    @Override
    public long getCacheXaRollbacksMostRecentSample() {
        return this.cacheXaRollbackCount.getMostRecentSample().getCounterValue();
    }

    @Override
    public void notifyXaRollback() {
        this.incrementIfStatsEnabled(this.cacheXaRollbackCount);
    }
}

