/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.logging.diagnostic.domain.DiagnosticAttribute;
import com.jaspersoft.jasperserver.api.logging.diagnostic.helper.DiagnosticAttributeBuilder;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.Diagnostic;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.DiagnosticCallback;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.search.SearchCriteriaFactory;
import com.jaspersoft.jasperserver.api.search.SearchFilter;
import com.jaspersoft.jasperserver.api.search.SearchSorter;
import com.jaspersoft.jasperserver.api.search.TransformerFactory;
import com.jaspersoft.jasperserver.search.common.CustomFilter;
import com.jaspersoft.jasperserver.search.common.CustomSorter;
import com.jaspersoft.jasperserver.search.common.RepositorySearchConfiguration;
import com.jaspersoft.jasperserver.search.common.ResourceDetails;
import com.jaspersoft.jasperserver.search.filter.AccessTypeFilter;
import com.jaspersoft.jasperserver.search.filter.TextFilter;
import com.jaspersoft.jasperserver.search.mode.AccessType;
import com.jaspersoft.jasperserver.search.mode.SearchMode;
import com.jaspersoft.jasperserver.search.mode.SearchModeSettingsResolver;
import com.jaspersoft.jasperserver.search.service.ChildrenLoaderService;
import com.jaspersoft.jasperserver.search.service.RepositorySearchCriteria;
import com.jaspersoft.jasperserver.search.service.RepositorySearchService;
import com.jaspersoft.jasperserver.search.service.ResourceService;
import com.jaspersoft.jasperserver.search.service.impl.RepositorySearchCriteriaImpl;
import com.jaspersoft.jasperserver.search.sorter.ByLabelSorter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class RepositorySearchServiceImpl
implements RepositorySearchService,
Diagnostic {
    protected RepositoryService repositoryService;
    private ResourceService resourceService;
    protected TransformerFactory transformerFactory;
    private Map<String, ChildrenLoaderService> childrenLoaders;
    protected SearchCriteriaFactory defaultSearchCriteriaFactory;
    private SearchModeSettingsResolver searchModeSettingsResolver;
    protected Map<String, List<String>> filterOptionToResourceTypes;
    protected ByLabelSorter sorter;
    @Resource
    private TextFilter textFilter;
    @Resource
    private AccessTypeFilter accessTypeFilter;

    public ByLabelSorter getSorter() {
        return this.sorter;
    }

    public void setSorter(ByLabelSorter sorter) {
        this.sorter = sorter;
    }

    public void setSearchModeSettingsResolver(SearchModeSettingsResolver searchModeSettingsResolver) {
        this.searchModeSettingsResolver = searchModeSettingsResolver;
    }

    public void setDefaultSearchCriteriaFactory(SearchCriteriaFactory defaultSearchCriteriaFactory) {
        this.defaultSearchCriteriaFactory = defaultSearchCriteriaFactory;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public void setFilterOptionToResourceTypes(Map<String, List<String>> filterOptionToResourceTypes) {
        this.filterOptionToResourceTypes = filterOptionToResourceTypes;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<ResourceDetails> getResults(ExecutionContext context, SearchCriteriaFactory searchCriteriaFactory, List<SearchFilter> filters, SearchSorter sorter, int current, int max) {
        List<ResourceLookup> resources = this.getLookups(context, searchCriteriaFactory, filters, sorter, current, max);
        return this.getResourceDetailsList(resources);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<ResourceDetails> getResults(ExecutionContext context, RepositorySearchCriteria criteria) {
        List<ResourceLookup> resources = this.getLookups(context, criteria);
        return this.getResourceDetailsList(resources);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<ResourceLookup> getLookups(ExecutionContext context, SearchCriteriaFactory searchCriteriaFactory, List<SearchFilter> filters, SearchSorter sorter, int current, int max) {
        return this.repositoryService.getResources(context, searchCriteriaFactory, filters, sorter, this.transformerFactory, current, max);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<ResourceLookup> getLookups(ExecutionContext context, RepositorySearchCriteria criteria) {
        context = this.putCriteriaToContext(context, criteria);
        RepositorySearchConfiguration configuration = this.getConfiguration(criteria.getSearchMode() != null ? criteria.getSearchMode() : SearchMode.SEARCH);
        return this.getLookups(context, this.obtainFactory(criteria), this.createAllFiltersList(configuration, criteria), this.getSorter(configuration, criteria.getSortBy()), criteria.getStartIndex(), criteria.getMaxCount());
    }

    @Override
    public int getResultsCount(ExecutionContext context, RepositorySearchCriteria criteria) {
        context = this.putCriteriaToContext(context, criteria);
        RepositorySearchConfiguration configuration = this.getConfiguration(criteria.getSearchMode() != null ? criteria.getSearchMode() : SearchMode.SEARCH);
        return this.getResultsCount(context, this.obtainFactory(criteria), this.createAllFiltersList(configuration, criteria), this.getSorter(configuration, criteria.getSortBy()));
    }

    public Map<DiagnosticAttribute, DiagnosticCallback> getDiagnosticData() {
        final RepositorySearchCriteria repositorySearchCriteria = new RepositorySearchCriteriaImpl.Builder().setFolderUri("/").setSearchText(null).setStartIndex(0).setMaxCount(0).setSearchMode(SearchMode.SEARCH).setSortBy("name").getCriteria();
        final RepositorySearchConfiguration configuration = this.getConfiguration(repositorySearchCriteria.getSearchMode());
        final SearchCriteriaFactory factory = this.defaultSearchCriteriaFactory.newFactory(com.jaspersoft.jasperserver.api.metadata.common.domain.Resource.class.getCanonicalName());
        final ByLabelSorter searchSorter = this.getSorter();
        return new DiagnosticAttributeBuilder().addDiagnosticAttribute("TotalReportsCount", (DiagnosticCallback)new DiagnosticCallback<Integer>(){

            public Integer getDiagnosticAttributeValue() {
                ArrayList<SearchFilter> allFiltersList = new ArrayList<SearchFilter>(RepositorySearchServiceImpl.this.createAllFiltersList(configuration, repositorySearchCriteria));
                repositorySearchCriteria.setResourceTypes(RepositorySearchServiceImpl.this.filterOptionToResourceTypes.get("resourceTypeFilter-reports"));
                return RepositorySearchServiceImpl.this.repositoryService.getResourcesCount(RepositorySearchServiceImpl.this.putCriteriaToContext(null, repositorySearchCriteria), factory, allFiltersList, searchSorter, RepositorySearchServiceImpl.this.transformerFactory);
            }
        }).addDiagnosticAttribute("TotalReportOutputsCount", (DiagnosticCallback)new DiagnosticCallback<Integer>(){

            public Integer getDiagnosticAttributeValue() {
                ArrayList<SearchFilter> allFiltersList = new ArrayList<SearchFilter>(RepositorySearchServiceImpl.this.createAllFiltersList(configuration, repositorySearchCriteria));
                repositorySearchCriteria.setResourceTypes(RepositorySearchServiceImpl.this.filterOptionToResourceTypes.get("resourceTypeFilter-reportOutput"));
                return RepositorySearchServiceImpl.this.repositoryService.getResourcesCount(RepositorySearchServiceImpl.this.putCriteriaToContext(null, repositorySearchCriteria), factory, allFiltersList, searchSorter, RepositorySearchServiceImpl.this.transformerFactory);
            }
        }).addDiagnosticAttribute("TotalFoldersCount", (DiagnosticCallback)new DiagnosticCallback<Integer>(){

            public Integer getDiagnosticAttributeValue() {
                return RepositorySearchServiceImpl.this.repositoryService.getAllFolders(null).size();
            }
        }).addDiagnosticAttribute("TotalOlapViewsCount", (DiagnosticCallback)new DiagnosticCallback<Integer>(){

            public Integer getDiagnosticAttributeValue() {
                ArrayList<SearchFilter> allFiltersList = new ArrayList<SearchFilter>(RepositorySearchServiceImpl.this.createAllFiltersList(configuration, repositorySearchCriteria));
                repositorySearchCriteria.setResourceTypes(RepositorySearchServiceImpl.this.filterOptionToResourceTypes.get("resourceTypeFilter-view"));
                return RepositorySearchServiceImpl.this.repositoryService.getResourcesCount(RepositorySearchServiceImpl.this.putCriteriaToContext(null, repositorySearchCriteria), factory, allFiltersList, searchSorter, RepositorySearchServiceImpl.this.transformerFactory);
            }
        }).addDiagnosticAttribute("TotalDataSourcesCount", (DiagnosticCallback)new DiagnosticCallback<Integer>(){

            public Integer getDiagnosticAttributeValue() {
                ArrayList<SearchFilter> allFiltersList = new ArrayList<SearchFilter>(RepositorySearchServiceImpl.this.createAllFiltersList(configuration, repositorySearchCriteria));
                repositorySearchCriteria.setResourceTypes(RepositorySearchServiceImpl.this.filterOptionToResourceTypes.get("resourceTypeFilter-dataSources"));
                return RepositorySearchServiceImpl.this.repositoryService.getResourcesCount(RepositorySearchServiceImpl.this.putCriteriaToContext(null, repositorySearchCriteria), factory, allFiltersList, searchSorter, RepositorySearchServiceImpl.this.transformerFactory);
            }
        }).build();
    }

    protected ExecutionContext putCriteriaToContext(ExecutionContext context, RepositorySearchCriteria criteria) {
        ExecutionContext nullSafeContext;
        ExecutionContext executionContext = nullSafeContext = context != null ? context : ExecutionContextImpl.getRuntimeExecutionContext();
        if (nullSafeContext.getAttributes() == null) {
            nullSafeContext.setAttributes(new ArrayList());
        }
        nullSafeContext.getAttributes().add(criteria);
        return nullSafeContext;
    }

    public SearchSorter getSorter(RepositorySearchConfiguration configuration, String sortBy) {
        SearchSorter result = null;
        SearchSorter defaultSorter = null;
        for (CustomSorter sorter : configuration.getCustomSorters()) {
            if (sorter.getId().equals(sortBy)) {
                result = sorter.getSearchSorter();
                break;
            }
            if (!sorter.isDefault()) continue;
            defaultSorter = sorter.getSearchSorter();
        }
        return result != null ? result : defaultSorter;
    }

    protected RepositorySearchConfiguration getConfiguration(SearchMode searchMode) {
        return this.searchModeSettingsResolver.getSettings(searchMode).getRepositorySearchConfiguration();
    }

    protected List<SearchFilter> createAllFiltersList(RepositorySearchConfiguration configuration, RepositorySearchCriteria criteria) {
        ArrayList<SearchFilter> filterList = new ArrayList<SearchFilter>();
        filterList.addAll(configuration.getSystemFilters());
        filterList.addAll(this.getRestrictionsFilters(configuration));
        for (int aTextFilterIndex = 0; aTextFilterIndex < filterList.size(); ++aTextFilterIndex) {
            if (!(filterList.get(aTextFilterIndex) instanceof TextFilter)) continue;
            filterList.remove(aTextFilterIndex);
            filterList.add(aTextFilterIndex, this.textFilter);
        }
        if (!criteria.getAccessType().equals((Object)AccessType.ALL)) {
            if (criteria.getCustomFilters() == null) {
                criteria.setCustomFilters(new LinkedList<SearchFilter>());
            }
            criteria.getCustomFilters().add(this.accessTypeFilter);
        }
        if (criteria != null && criteria.getCustomFilters() != null && !criteria.getCustomFilters().isEmpty()) {
            filterList.addAll(criteria.getCustomFilters());
        }
        return filterList;
    }

    protected List<SearchFilter> getRestrictionsFilters(RepositorySearchConfiguration configuration) {
        HashSet<String> customFilerIds = new HashSet<String>(configuration.getCustomFiltersMap().keySet());
        ArrayList<SearchFilter> filters = new ArrayList<SearchFilter>();
        if (customFilerIds != null && !customFilerIds.isEmpty()) {
            for (CustomFilter filter : configuration.getCustomFilters()) {
                if (!customFilerIds.contains(filter.getId())) continue;
                filters.add(filter.getFilter());
            }
        }
        return filters;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int getResultsCount(ExecutionContext context, SearchCriteriaFactory searchCriteriaFactory, List<SearchFilter> filters, SearchSorter sorter) {
        return this.repositoryService.getResourcesCount(context, searchCriteriaFactory, filters, sorter, this.transformerFactory);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<ResourceDetails> getResourceChildren(String type, String resourceUri) {
        ChildrenLoaderService childrenLoaderService = this.childrenLoaders.get(type);
        if (childrenLoaderService != null) {
            return this.getResourceDetailsList(childrenLoaderService.getChildren(resourceUri));
        }
        return Collections.emptyList();
    }

    private List<ResourceDetails> getResourceDetailsList(List<ResourceLookup> resources) {
        ArrayList<ResourceDetails> list = new ArrayList<ResourceDetails>();
        for (ResourceLookup resource : resources) {
            ResourceDetails resourceDetails = this.resourceService.getResourceDetails((com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)resource);
            list.add(resourceDetails);
        }
        return list;
    }

    public void setChildrenLoaders(Map<String, ChildrenLoaderService> childrenLoaders) {
        this.childrenLoaders = childrenLoaders;
    }

    private SearchCriteriaFactory obtainFactory(RepositorySearchCriteria criteria) {
        SearchCriteriaFactory res;
        if (criteria.isExcludeFolders() || !criteria.getAccessType().equals((Object)AccessType.ALL)) {
            if (criteria.getResourceTypes() != null && criteria.getResourceTypes().size() == 1 && criteria.getCustomFilters() != null && !criteria.getCustomFilters().isEmpty()) {
                res = this.defaultSearchCriteriaFactory.newFactory(criteria.getResourceTypes().get(0));
                criteria.getResourceTypes().clear();
            } else {
                res = this.defaultSearchCriteriaFactory.newFactory(null);
            }
        } else {
            res = this.defaultSearchCriteriaFactory.newFactory(ResourceLookup.class.getName());
        }
        return res;
    }
}

