/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.util.spring;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.util.spring.AbstractBeanPropertyProcessor;
import com.jaspersoft.jasperserver.api.common.util.spring.GenericBeanUpdaterDefinition;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.beans.factory.support.ManagedSet;

public class GenericBeanUpdater
extends AbstractBeanPropertyProcessor {
    public static final String TYPE_STRING = "string";
    public static final String TYPE_REF = "ref";
    public static final String TYPE_IDREF = "idRef";
    public static final String TYPE_STRING_LIST = "stringList";
    public static final String TYPE_REF_LIST = "refList";
    public static final String TYPE_IDREF_LIST = "idRefList";
    public static final String TYPE_IDREF_MAP = "idRefMap";
    public static final String TYPE_STRING_SET = "stringSet";
    public static final String TYPE_STRING_MAP = "stringMap";
    public static final String TYPE_REF_MAP = "refMap";
    public static final String TYPE_STRING_PROPERTIES = "stringProperties";
    private GenericBeanUpdaterDefinition definition;
    private String key;
    private Object value;
    private String valueType;
    private String before;
    private String after;
    private int order = 0;
    private boolean orderSet = false;
    private String oldValue = null;
    private String replacement = null;

    @Override
    protected Object getProcessedPropertyValue(Object originalValue) {
        try {
            if (this.definition.getOperation().equals("append")) {
                return this.append(originalValue);
            }
            if (this.definition.getOperation().equals("set")) {
                return this.set(originalValue);
            }
            if (this.definition.getOperation().equals("insert")) {
                return this.insert(originalValue);
            }
            if (this.definition.getOperation().equals("replace")) {
                return this.replace(originalValue);
            }
            throw new JSException("jsexception.unknown.updater.operation", new Object[]{this.getBeanName(), this.definition.getOperation()});
        }
        catch (Throwable ex) {
            throw new RuntimeException("Bean updater failure. Operation: " + this.definition.getOperation() + " on bean: " + this.getBeanName() + " for property: " + this.getPropertyName() + " with value: " + this.value + ", value type: " + this.valueType, ex);
        }
    }

    private Object append(Object originalValue) {
        if (originalValue == null) {
            return this.getSinglePropertyValue();
        }
        if (TYPE_STRING_MAP.equals(this.valueType)) {
            ManagedMap newValue = new ManagedMap();
            newValue.putAll((Map)originalValue);
            if (this.key != null) {
                newValue.put(new TypedStringValue(this.key), new TypedStringValue((String)this.value));
            } else if (this.value instanceof Map) {
                newValue.putAll((Map)GenericBeanUpdater.convertToMetaData(this.value, TYPE_STRING_MAP));
            } else {
                throw new JSException("jsexception.cant.append.to.map", new Object[]{this.getPropertyName(), this.getBeanName(), this.value});
            }
            return newValue;
        }
        if (TYPE_STRING_PROPERTIES.equals(this.valueType)) {
            ManagedProperties newValue = new ManagedProperties();
            newValue.putAll((Properties)originalValue);
            if (this.key != null) {
                newValue.put(new TypedStringValue(this.key), new TypedStringValue((String)this.value));
            } else if (this.value instanceof Properties) {
                newValue.putAll((Properties)GenericBeanUpdater.convertToMetaData(this.value, TYPE_STRING_PROPERTIES));
            } else {
                throw new JSException("jsexception.cant.append.to.properties", new Object[]{this.getPropertyName(), this.getBeanName(), this.value});
            }
            return newValue;
        }
        if (TYPE_STRING_LIST.equals(this.valueType)) {
            ManagedList newValue = new ManagedList();
            newValue.addAll((List)originalValue);
            if (this.value instanceof List) {
                newValue.addAll((List)GenericBeanUpdater.convertToMetaData(this.value, TYPE_STRING_LIST));
            } else if (this.value instanceof String) {
                newValue.add(GenericBeanUpdater.convertToMetaData(this.value, TYPE_STRING));
            } else {
                throw new JSException("jsexception.cant.append", new Object[]{this.getPropertyName(), this.getBeanName(), this.value});
            }
            return newValue;
        }
        if (TYPE_REF_LIST.equals(this.valueType)) {
            ManagedList newValue = new ManagedList();
            newValue.addAll((List)originalValue);
            if (this.value instanceof List) {
                newValue.addAll((List)GenericBeanUpdater.convertToMetaData(this.value, TYPE_REF_LIST));
            } else if (this.value instanceof String) {
                newValue.add(GenericBeanUpdater.convertToMetaData(this.value, TYPE_REF));
            } else {
                throw new JSException("jsexception.cant.append", new Object[]{this.getPropertyName(), this.getBeanName(), this.value});
            }
            return newValue;
        }
        if (TYPE_IDREF_LIST.equals(this.valueType)) {
            ManagedList newValue = new ManagedList();
            newValue.addAll((List)originalValue);
            if (this.value instanceof List) {
                newValue.addAll((List)GenericBeanUpdater.convertToMetaData(this.value, TYPE_IDREF_LIST));
            } else if (this.value instanceof String) {
                newValue.add(GenericBeanUpdater.convertToMetaData(this.value, TYPE_IDREF));
            } else {
                throw new JSException("jsexception.cant.append", new Object[]{this.getPropertyName(), this.getBeanName(), this.value});
            }
            return newValue;
        }
        if (TYPE_IDREF_MAP.equals(this.valueType)) {
            ManagedMap newValue = new ManagedMap();
            newValue.putAll((Map)originalValue);
            if (this.key != null) {
                newValue.put(new TypedStringValue(this.key), GenericBeanUpdater.convertToMetaData(this.value, TYPE_REF));
            } else if (this.value instanceof Map) {
                newValue.putAll((Map)GenericBeanUpdater.convertToMetaData(this.value, TYPE_IDREF_MAP));
            } else {
                throw new JSException("jsexception.cant.append", new Object[]{this.getPropertyName(), this.getBeanName(), this.value});
            }
            return newValue;
        }
        if (TYPE_REF_MAP.equals(this.valueType)) {
            ManagedMap newValue = new ManagedMap();
            newValue.putAll((Map)originalValue);
            if (this.key != null) {
                newValue.put(new TypedStringValue(this.key), GenericBeanUpdater.convertToMetaData(this.value, TYPE_REF));
            } else if (this.value instanceof Map) {
                newValue.putAll((Map)GenericBeanUpdater.convertToMetaData(this.value, TYPE_REF_MAP));
            } else {
                throw new JSException("jsexception.cant.append", new Object[]{this.getPropertyName(), this.getBeanName(), this.value});
            }
            return newValue;
        }
        if (originalValue instanceof TypedStringValue) {
            return new TypedStringValue(((TypedStringValue)originalValue).getValue() + this.value);
        }
        throw new JSException("jsexception.cant.append", new Object[]{this.getPropertyName(), this.getBeanName(), this.value});
    }

    private Object set(Object originalValue) {
        return this.getSinglePropertyValue();
    }

    private Object insert(Object originalValue) {
        if (originalValue instanceof TypedStringValue) {
            StringBuffer newValue = new StringBuffer(((TypedStringValue)originalValue).getValue());
            int index = 0;
            if (this.before != null) {
                index = newValue.indexOf(this.before);
                if (index == -1) {
                    throw new JSException("jsexception.cant.find.before.string", new Object[]{this.getPropertyName(), this.getBeanName(), this.value});
                }
                do {
                    newValue.insert(index, this.value);
                } while ((index = newValue.indexOf(this.before, newValue.indexOf(this.before, index) + 1)) > 0);
            } else if (this.after != null && !"".equals(this.after)) {
                index = newValue.indexOf(this.after);
                if (index == -1) {
                    throw new JSException("jsexception.cant.find.after.string", new Object[]{this.getPropertyName(), this.getBeanName(), this.value});
                }
                do {
                    newValue.insert(index += this.after.length(), this.value);
                } while ((index = newValue.indexOf(this.after, index)) > 0);
            } else {
                newValue.insert(index, this.value);
            }
            return new TypedStringValue(newValue.toString());
        }
        throw new JSException("jsexception.cant.insert", new Object[]{this.getPropertyName(), this.getBeanName(), this.value});
    }

    private Object replace(Object originalValue) {
        if (TYPE_STRING.equals(this.valueType)) {
            return new TypedStringValue(((TypedStringValue)originalValue).getValue().replaceAll(this.oldValue, this.replacement));
        }
        throw new JSException("jsexception.cant.insert", new Object[]{this.getPropertyName(), this.getBeanName(), this.value});
    }

    @Override
    public String getBeanName() {
        return this.definition.getBeanName();
    }

    protected Object getSinglePropertyValue() {
        Object propValue = this.value != null ? GenericBeanUpdater.convertToMetaData(this.value, this.valueType) : null;
        return propValue;
    }

    @Override
    public int getOrder() {
        return this.orderSet ? this.order : this.definition.getOrder();
    }

    @Override
    public void setOrder(int order) {
        this.orderSet = true;
        this.order = order;
    }

    @Override
    public String getPropertyName() {
        return this.definition.getPropertyName();
    }

    public GenericBeanUpdaterDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(GenericBeanUpdaterDefinition definition) {
        this.definition = definition;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public String getBefore() {
        return this.before;
    }

    public void setBefore(String before) {
        this.before = before;
    }

    public String getAfter() {
        return this.after;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String val) {
        this.oldValue = val;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    protected static Object convertToMetaData(Object value, String valueType) {
        if (value != null && valueType != null) {
            if (TYPE_STRING.equals(valueType)) {
                return new TypedStringValue((String)value);
            }
            if (TYPE_STRING_LIST.equals(valueType)) {
                ManagedList list = new ManagedList();
                Iterator iter = ((List)value).iterator();
                while (iter.hasNext()) {
                    list.add(GenericBeanUpdater.convertToMetaData(iter.next(), TYPE_STRING));
                }
                return list;
            }
            if (TYPE_STRING_SET.equals(valueType)) {
                ManagedSet newSet = new ManagedSet();
                Iterator iter = ((Set)value).iterator();
                while (iter.hasNext()) {
                    newSet.add(GenericBeanUpdater.convertToMetaData(iter.next(), TYPE_STRING));
                }
                return newSet;
            }
            if (TYPE_STRING_PROPERTIES.equals(valueType)) {
                ManagedProperties newProperties = new ManagedProperties();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    newProperties.put(GenericBeanUpdater.convertToMetaData(entry.getKey(), TYPE_STRING), GenericBeanUpdater.convertToMetaData(entry.getValue(), TYPE_STRING));
                }
                return newProperties;
            }
            if (TYPE_STRING_MAP.equals(valueType)) {
                ManagedMap newMap = new ManagedMap();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    newMap.put(GenericBeanUpdater.convertToMetaData(entry.getKey(), TYPE_STRING), GenericBeanUpdater.convertToMetaData(entry.getValue(), TYPE_STRING));
                }
                return newMap;
            }
            if (TYPE_IDREF.equals(valueType)) {
                return new RuntimeBeanReference((String)value);
            }
            if (TYPE_IDREF_LIST.equals(valueType)) {
                ManagedList list = new ManagedList();
                Iterator iter = ((List)value).iterator();
                while (iter.hasNext()) {
                    list.add(GenericBeanUpdater.convertToMetaData(iter.next(), TYPE_IDREF));
                }
                return list;
            }
            if (TYPE_IDREF_MAP.equals(valueType)) {
                ManagedMap newMap = new ManagedMap();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    newMap.put(GenericBeanUpdater.convertToMetaData(entry.getKey(), TYPE_STRING), GenericBeanUpdater.convertToMetaData(entry.getValue(), TYPE_IDREF));
                }
                return newMap;
            }
            if (TYPE_REF_MAP.equals(valueType)) {
                ManagedMap newMap = new ManagedMap();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    newMap.put(GenericBeanUpdater.convertToMetaData(entry.getKey(), TYPE_STRING), GenericBeanUpdater.convertToMetaData(entry.getValue(), TYPE_REF));
                }
                return newMap;
            }
        }
        return value;
    }
}

