/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql.packet.commands;

import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import org.mariadb.jdbc.internal.common.Utils;
import org.mariadb.jdbc.internal.common.packet.CommandPacket;
import org.mariadb.jdbc.internal.common.packet.PacketOutputStream;
import org.mariadb.jdbc.internal.common.packet.buffer.WriteBuffer;
import org.mariadb.jdbc.internal.mysql.MySQLServerCapabilities;

public class MySQLClientAuthPacket
implements CommandPacket {
    private final WriteBuffer writeBuffer;
    private final byte packetSeq;

    public MySQLClientAuthPacket(String username, String password, String database, Set<MySQLServerCapabilities> serverCapabilities, byte[] seed, byte packetSeq) {
        byte[] scrambledPassword;
        this.packetSeq = packetSeq;
        this.writeBuffer = new WriteBuffer();
        try {
            scrambledPassword = Utils.encryptPassword(password, seed);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not use SHA-1, failing", e);
        }
        int serverLanguage = 33;
        this.writeBuffer.writeInt(MySQLServerCapabilities.fromSet(serverCapabilities)).writeInt(0x40000000).writeByte((byte)33).writeBytes((byte)0, 23).writeString(username).writeByte((byte)0).writeByte((byte)scrambledPassword.length).writeByteArray(scrambledPassword);
        if (serverCapabilities.contains((Object)MySQLServerCapabilities.CONNECT_WITH_DB)) {
            this.writeBuffer.writeString(database).writeByte((byte)0);
        }
    }

    @Override
    public int send(OutputStream os) throws IOException {
        PacketOutputStream pos = (PacketOutputStream)os;
        pos.startPacket(this.packetSeq);
        os.write(this.writeBuffer.getBuffer(), 0, this.writeBuffer.getLength());
        pos.finishPacket();
        return 1;
    }
}

