/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql;

import java.text.ParseException;
import org.mariadb.jdbc.internal.common.AbstractValueObject;
import org.mariadb.jdbc.internal.common.ColumnInformation;
import org.mariadb.jdbc.internal.mysql.MySQLType;

public class MySQLValueObject
extends AbstractValueObject {
    ColumnInformation columnInfo;

    public MySQLValueObject(byte[] rawBytes, ColumnInformation columnInfo) {
        super(rawBytes, columnInfo.getType());
        this.columnInfo = columnInfo;
    }

    @Override
    public String getString() {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            return null;
        }
        if (this.columnInfo.getType().getType() == MySQLType.Type.BIT && this.columnInfo.getLength() == 1L) {
            return bytes[0] == 0 ? "false" : "true";
        }
        return super.getString();
    }

    @Override
    public Object getObject(int datatypeMappingFlags) throws ParseException {
        if (this.getBytes() == null) {
            return null;
        }
        switch (this.dataType.getType()) {
            case BIT: {
                if (this.columnInfo.getLength() == 1L) {
                    return this.getBytes()[0] != 0;
                }
                return this.getBytes();
            }
            case TINYINT: {
                if ((datatypeMappingFlags & 1) != 0 && this.columnInfo.getLength() == 1L) {
                    return this.getBytes()[0] != 48;
                }
                return this.getInt();
            }
            case INTEGER: {
                if (!this.columnInfo.isSigned()) {
                    return this.getLong();
                }
                return this.getInt();
            }
            case BIGINT: {
                if (!this.columnInfo.isSigned()) {
                    return this.getBigInteger();
                }
                return this.getLong();
            }
            case DOUBLE: {
                return this.getDouble();
            }
            case TIMESTAMP: {
                return this.getTimestamp();
            }
            case DATETIME: {
                return this.getTimestamp();
            }
            case DATE: {
                return this.getDate();
            }
            case VARCHAR: {
                if (this.columnInfo.isBinary()) {
                    return this.getBytes();
                }
                return this.getString();
            }
            case DECIMAL: {
                return this.getBigDecimal();
            }
            case BLOB: {
                return this.getBytes();
            }
            case LONGBLOB: {
                return this.getBytes();
            }
            case MEDIUMBLOB: {
                return this.getBytes();
            }
            case TINYBLOB: {
                return this.getBytes();
            }
            case NULL: {
                return null;
            }
            case YEAR: {
                if ((datatypeMappingFlags & 2) != 0) {
                    return this.getDate();
                }
                return this.getShort();
            }
            case SMALLINT: 
            case MEDIUMINT: {
                return this.getInt();
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat());
            }
            case TIME: {
                return this.getTime();
            }
            case CLOB: {
                return this.getString();
            }
            case CHAR: {
                if (this.columnInfo.isBinary()) {
                    return this.getBytes();
                }
                return this.getString();
            }
            case OLDDECIMAL: {
                return this.getString();
            }
        }
        return null;
    }
}

