/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkAsync;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient;
import com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest;
import com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationResult;
import com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest;
import com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEventsResult;
import com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest;
import com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksResult;
import com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest;
import com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest;
import com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest;
import com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoResult;
import com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest;
import com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentResult;
import com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest;
import com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSElasticBeanstalkAsyncClient
extends AWSElasticBeanstalkClient
implements AWSElasticBeanstalkAsync {
    private ExecutorService executorService;

    public AWSElasticBeanstalkAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AWSElasticBeanstalkAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public AWSElasticBeanstalkAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AWSElasticBeanstalkAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AWSElasticBeanstalkAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSElasticBeanstalkAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AWSElasticBeanstalkAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSElasticBeanstalkAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newCachedThreadPool());
    }

    public AWSElasticBeanstalkAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<CheckDNSAvailabilityResult> checkDNSAvailabilityAsync(final CheckDNSAvailabilityRequest checkDNSAvailabilityRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CheckDNSAvailabilityResult>(){

            @Override
            public CheckDNSAvailabilityResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.checkDNSAvailability(checkDNSAvailabilityRequest);
            }
        });
    }

    @Override
    public Future<CheckDNSAvailabilityResult> checkDNSAvailabilityAsync(final CheckDNSAvailabilityRequest checkDNSAvailabilityRequest, final AsyncHandler<CheckDNSAvailabilityRequest, CheckDNSAvailabilityResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CheckDNSAvailabilityResult>(){

            @Override
            public CheckDNSAvailabilityResult call() throws Exception {
                CheckDNSAvailabilityResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.checkDNSAvailability(checkDNSAvailabilityRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(checkDNSAvailabilityRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationOptionsResult> describeConfigurationOptionsAsync(final DescribeConfigurationOptionsRequest describeConfigurationOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConfigurationOptionsResult>(){

            @Override
            public DescribeConfigurationOptionsResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.describeConfigurationOptions(describeConfigurationOptionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeConfigurationOptionsResult> describeConfigurationOptionsAsync(final DescribeConfigurationOptionsRequest describeConfigurationOptionsRequest, final AsyncHandler<DescribeConfigurationOptionsRequest, DescribeConfigurationOptionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConfigurationOptionsResult>(){

            @Override
            public DescribeConfigurationOptionsResult call() throws Exception {
                DescribeConfigurationOptionsResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.describeConfigurationOptions(describeConfigurationOptionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeConfigurationOptionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteConfigurationTemplateAsync(final DeleteConfigurationTemplateRequest deleteConfigurationTemplateRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSElasticBeanstalkAsyncClient.this.deleteConfigurationTemplate(deleteConfigurationTemplateRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteConfigurationTemplateAsync(final DeleteConfigurationTemplateRequest deleteConfigurationTemplateRequest, final AsyncHandler<DeleteConfigurationTemplateRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSElasticBeanstalkAsyncClient.this.deleteConfigurationTemplate(deleteConfigurationTemplateRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteConfigurationTemplateRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CreateEnvironmentResult> createEnvironmentAsync(final CreateEnvironmentRequest createEnvironmentRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateEnvironmentResult>(){

            @Override
            public CreateEnvironmentResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.createEnvironment(createEnvironmentRequest);
            }
        });
    }

    @Override
    public Future<CreateEnvironmentResult> createEnvironmentAsync(final CreateEnvironmentRequest createEnvironmentRequest, final AsyncHandler<CreateEnvironmentRequest, CreateEnvironmentResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateEnvironmentResult>(){

            @Override
            public CreateEnvironmentResult call() throws Exception {
                CreateEnvironmentResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.createEnvironment(createEnvironmentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createEnvironmentRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateStorageLocationResult> createStorageLocationAsync(final CreateStorageLocationRequest createStorageLocationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateStorageLocationResult>(){

            @Override
            public CreateStorageLocationResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.createStorageLocation(createStorageLocationRequest);
            }
        });
    }

    @Override
    public Future<CreateStorageLocationResult> createStorageLocationAsync(final CreateStorageLocationRequest createStorageLocationRequest, final AsyncHandler<CreateStorageLocationRequest, CreateStorageLocationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateStorageLocationResult>(){

            @Override
            public CreateStorageLocationResult call() throws Exception {
                CreateStorageLocationResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.createStorageLocation(createStorageLocationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createStorageLocationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> requestEnvironmentInfoAsync(final RequestEnvironmentInfoRequest requestEnvironmentInfoRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSElasticBeanstalkAsyncClient.this.requestEnvironmentInfo(requestEnvironmentInfoRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> requestEnvironmentInfoAsync(final RequestEnvironmentInfoRequest requestEnvironmentInfoRequest, final AsyncHandler<RequestEnvironmentInfoRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSElasticBeanstalkAsyncClient.this.requestEnvironmentInfo(requestEnvironmentInfoRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(requestEnvironmentInfoRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<CreateApplicationVersionResult> createApplicationVersionAsync(final CreateApplicationVersionRequest createApplicationVersionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateApplicationVersionResult>(){

            @Override
            public CreateApplicationVersionResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.createApplicationVersion(createApplicationVersionRequest);
            }
        });
    }

    @Override
    public Future<CreateApplicationVersionResult> createApplicationVersionAsync(final CreateApplicationVersionRequest createApplicationVersionRequest, final AsyncHandler<CreateApplicationVersionRequest, CreateApplicationVersionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateApplicationVersionResult>(){

            @Override
            public CreateApplicationVersionResult call() throws Exception {
                CreateApplicationVersionResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.createApplicationVersion(createApplicationVersionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createApplicationVersionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteApplicationVersionAsync(final DeleteApplicationVersionRequest deleteApplicationVersionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSElasticBeanstalkAsyncClient.this.deleteApplicationVersion(deleteApplicationVersionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteApplicationVersionAsync(final DeleteApplicationVersionRequest deleteApplicationVersionRequest, final AsyncHandler<DeleteApplicationVersionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSElasticBeanstalkAsyncClient.this.deleteApplicationVersion(deleteApplicationVersionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteApplicationVersionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeApplicationVersionsResult> describeApplicationVersionsAsync(final DescribeApplicationVersionsRequest describeApplicationVersionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeApplicationVersionsResult>(){

            @Override
            public DescribeApplicationVersionsResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.describeApplicationVersions(describeApplicationVersionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeApplicationVersionsResult> describeApplicationVersionsAsync(final DescribeApplicationVersionsRequest describeApplicationVersionsRequest, final AsyncHandler<DescribeApplicationVersionsRequest, DescribeApplicationVersionsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeApplicationVersionsResult>(){

            @Override
            public DescribeApplicationVersionsResult call() throws Exception {
                DescribeApplicationVersionsResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.describeApplicationVersions(describeApplicationVersionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeApplicationVersionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteApplicationAsync(final DeleteApplicationRequest deleteApplicationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSElasticBeanstalkAsyncClient.this.deleteApplication(deleteApplicationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteApplicationAsync(final DeleteApplicationRequest deleteApplicationRequest, final AsyncHandler<DeleteApplicationRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSElasticBeanstalkAsyncClient.this.deleteApplication(deleteApplicationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteApplicationRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<UpdateApplicationVersionResult> updateApplicationVersionAsync(final UpdateApplicationVersionRequest updateApplicationVersionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateApplicationVersionResult>(){

            @Override
            public UpdateApplicationVersionResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.updateApplicationVersion(updateApplicationVersionRequest);
            }
        });
    }

    @Override
    public Future<UpdateApplicationVersionResult> updateApplicationVersionAsync(final UpdateApplicationVersionRequest updateApplicationVersionRequest, final AsyncHandler<UpdateApplicationVersionRequest, UpdateApplicationVersionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateApplicationVersionResult>(){

            @Override
            public UpdateApplicationVersionResult call() throws Exception {
                UpdateApplicationVersionResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.updateApplicationVersion(updateApplicationVersionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateApplicationVersionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(final CreateApplicationRequest createApplicationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateApplicationResult>(){

            @Override
            public CreateApplicationResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.createApplication(createApplicationRequest);
            }
        });
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(final CreateApplicationRequest createApplicationRequest, final AsyncHandler<CreateApplicationRequest, CreateApplicationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateApplicationResult>(){

            @Override
            public CreateApplicationResult call() throws Exception {
                CreateApplicationResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.createApplication(createApplicationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createApplicationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> swapEnvironmentCNAMEsAsync(final SwapEnvironmentCNAMEsRequest swapEnvironmentCNAMEsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSElasticBeanstalkAsyncClient.this.swapEnvironmentCNAMEs(swapEnvironmentCNAMEsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> swapEnvironmentCNAMEsAsync(final SwapEnvironmentCNAMEsRequest swapEnvironmentCNAMEsRequest, final AsyncHandler<SwapEnvironmentCNAMEsRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSElasticBeanstalkAsyncClient.this.swapEnvironmentCNAMEs(swapEnvironmentCNAMEsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(swapEnvironmentCNAMEsRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<UpdateConfigurationTemplateResult> updateConfigurationTemplateAsync(final UpdateConfigurationTemplateRequest updateConfigurationTemplateRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateConfigurationTemplateResult>(){

            @Override
            public UpdateConfigurationTemplateResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.updateConfigurationTemplate(updateConfigurationTemplateRequest);
            }
        });
    }

    @Override
    public Future<UpdateConfigurationTemplateResult> updateConfigurationTemplateAsync(final UpdateConfigurationTemplateRequest updateConfigurationTemplateRequest, final AsyncHandler<UpdateConfigurationTemplateRequest, UpdateConfigurationTemplateResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateConfigurationTemplateResult>(){

            @Override
            public UpdateConfigurationTemplateResult call() throws Exception {
                UpdateConfigurationTemplateResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.updateConfigurationTemplate(updateConfigurationTemplateRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateConfigurationTemplateRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<RetrieveEnvironmentInfoResult> retrieveEnvironmentInfoAsync(final RetrieveEnvironmentInfoRequest retrieveEnvironmentInfoRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RetrieveEnvironmentInfoResult>(){

            @Override
            public RetrieveEnvironmentInfoResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.retrieveEnvironmentInfo(retrieveEnvironmentInfoRequest);
            }
        });
    }

    @Override
    public Future<RetrieveEnvironmentInfoResult> retrieveEnvironmentInfoAsync(final RetrieveEnvironmentInfoRequest retrieveEnvironmentInfoRequest, final AsyncHandler<RetrieveEnvironmentInfoRequest, RetrieveEnvironmentInfoResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RetrieveEnvironmentInfoResult>(){

            @Override
            public RetrieveEnvironmentInfoResult call() throws Exception {
                RetrieveEnvironmentInfoResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.retrieveEnvironmentInfo(retrieveEnvironmentInfoRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(retrieveEnvironmentInfoRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListAvailableSolutionStacksResult> listAvailableSolutionStacksAsync(final ListAvailableSolutionStacksRequest listAvailableSolutionStacksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListAvailableSolutionStacksResult>(){

            @Override
            public ListAvailableSolutionStacksResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.listAvailableSolutionStacks(listAvailableSolutionStacksRequest);
            }
        });
    }

    @Override
    public Future<ListAvailableSolutionStacksResult> listAvailableSolutionStacksAsync(final ListAvailableSolutionStacksRequest listAvailableSolutionStacksRequest, final AsyncHandler<ListAvailableSolutionStacksRequest, ListAvailableSolutionStacksResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListAvailableSolutionStacksResult>(){

            @Override
            public ListAvailableSolutionStacksResult call() throws Exception {
                ListAvailableSolutionStacksResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.listAvailableSolutionStacks(listAvailableSolutionStacksRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listAvailableSolutionStacksRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(final UpdateApplicationRequest updateApplicationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateApplicationResult>(){

            @Override
            public UpdateApplicationResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.updateApplication(updateApplicationRequest);
            }
        });
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(final UpdateApplicationRequest updateApplicationRequest, final AsyncHandler<UpdateApplicationRequest, UpdateApplicationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateApplicationResult>(){

            @Override
            public UpdateApplicationResult call() throws Exception {
                UpdateApplicationResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.updateApplication(updateApplicationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateApplicationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEnvironmentsResult> describeEnvironmentsAsync(final DescribeEnvironmentsRequest describeEnvironmentsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEnvironmentsResult>(){

            @Override
            public DescribeEnvironmentsResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.describeEnvironments(describeEnvironmentsRequest);
            }
        });
    }

    @Override
    public Future<DescribeEnvironmentsResult> describeEnvironmentsAsync(final DescribeEnvironmentsRequest describeEnvironmentsRequest, final AsyncHandler<DescribeEnvironmentsRequest, DescribeEnvironmentsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEnvironmentsResult>(){

            @Override
            public DescribeEnvironmentsResult call() throws Exception {
                DescribeEnvironmentsResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.describeEnvironments(describeEnvironmentsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeEnvironmentsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEnvironmentResourcesResult> describeEnvironmentResourcesAsync(final DescribeEnvironmentResourcesRequest describeEnvironmentResourcesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEnvironmentResourcesResult>(){

            @Override
            public DescribeEnvironmentResourcesResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.describeEnvironmentResources(describeEnvironmentResourcesRequest);
            }
        });
    }

    @Override
    public Future<DescribeEnvironmentResourcesResult> describeEnvironmentResourcesAsync(final DescribeEnvironmentResourcesRequest describeEnvironmentResourcesRequest, final AsyncHandler<DescribeEnvironmentResourcesRequest, DescribeEnvironmentResourcesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEnvironmentResourcesResult>(){

            @Override
            public DescribeEnvironmentResourcesResult call() throws Exception {
                DescribeEnvironmentResourcesResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.describeEnvironmentResources(describeEnvironmentResourcesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeEnvironmentResourcesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<TerminateEnvironmentResult> terminateEnvironmentAsync(final TerminateEnvironmentRequest terminateEnvironmentRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TerminateEnvironmentResult>(){

            @Override
            public TerminateEnvironmentResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.terminateEnvironment(terminateEnvironmentRequest);
            }
        });
    }

    @Override
    public Future<TerminateEnvironmentResult> terminateEnvironmentAsync(final TerminateEnvironmentRequest terminateEnvironmentRequest, final AsyncHandler<TerminateEnvironmentRequest, TerminateEnvironmentResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TerminateEnvironmentResult>(){

            @Override
            public TerminateEnvironmentResult call() throws Exception {
                TerminateEnvironmentResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.terminateEnvironment(terminateEnvironmentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(terminateEnvironmentRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ValidateConfigurationSettingsResult> validateConfigurationSettingsAsync(final ValidateConfigurationSettingsRequest validateConfigurationSettingsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ValidateConfigurationSettingsResult>(){

            @Override
            public ValidateConfigurationSettingsResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.validateConfigurationSettings(validateConfigurationSettingsRequest);
            }
        });
    }

    @Override
    public Future<ValidateConfigurationSettingsResult> validateConfigurationSettingsAsync(final ValidateConfigurationSettingsRequest validateConfigurationSettingsRequest, final AsyncHandler<ValidateConfigurationSettingsRequest, ValidateConfigurationSettingsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ValidateConfigurationSettingsResult>(){

            @Override
            public ValidateConfigurationSettingsResult call() throws Exception {
                ValidateConfigurationSettingsResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.validateConfigurationSettings(validateConfigurationSettingsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(validateConfigurationSettingsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> restartAppServerAsync(final RestartAppServerRequest restartAppServerRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSElasticBeanstalkAsyncClient.this.restartAppServer(restartAppServerRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> restartAppServerAsync(final RestartAppServerRequest restartAppServerRequest, final AsyncHandler<RestartAppServerRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSElasticBeanstalkAsyncClient.this.restartAppServer(restartAppServerRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(restartAppServerRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteEnvironmentConfigurationAsync(final DeleteEnvironmentConfigurationRequest deleteEnvironmentConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSElasticBeanstalkAsyncClient.this.deleteEnvironmentConfiguration(deleteEnvironmentConfigurationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteEnvironmentConfigurationAsync(final DeleteEnvironmentConfigurationRequest deleteEnvironmentConfigurationRequest, final AsyncHandler<DeleteEnvironmentConfigurationRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSElasticBeanstalkAsyncClient.this.deleteEnvironmentConfiguration(deleteEnvironmentConfigurationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteEnvironmentConfigurationRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<UpdateEnvironmentResult> updateEnvironmentAsync(final UpdateEnvironmentRequest updateEnvironmentRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateEnvironmentResult>(){

            @Override
            public UpdateEnvironmentResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.updateEnvironment(updateEnvironmentRequest);
            }
        });
    }

    @Override
    public Future<UpdateEnvironmentResult> updateEnvironmentAsync(final UpdateEnvironmentRequest updateEnvironmentRequest, final AsyncHandler<UpdateEnvironmentRequest, UpdateEnvironmentResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateEnvironmentResult>(){

            @Override
            public UpdateEnvironmentResult call() throws Exception {
                UpdateEnvironmentResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.updateEnvironment(updateEnvironmentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateEnvironmentRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateConfigurationTemplateResult> createConfigurationTemplateAsync(final CreateConfigurationTemplateRequest createConfigurationTemplateRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateConfigurationTemplateResult>(){

            @Override
            public CreateConfigurationTemplateResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.createConfigurationTemplate(createConfigurationTemplateRequest);
            }
        });
    }

    @Override
    public Future<CreateConfigurationTemplateResult> createConfigurationTemplateAsync(final CreateConfigurationTemplateRequest createConfigurationTemplateRequest, final AsyncHandler<CreateConfigurationTemplateRequest, CreateConfigurationTemplateResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateConfigurationTemplateResult>(){

            @Override
            public CreateConfigurationTemplateResult call() throws Exception {
                CreateConfigurationTemplateResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.createConfigurationTemplate(createConfigurationTemplateRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createConfigurationTemplateRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationSettingsResult> describeConfigurationSettingsAsync(final DescribeConfigurationSettingsRequest describeConfigurationSettingsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConfigurationSettingsResult>(){

            @Override
            public DescribeConfigurationSettingsResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.describeConfigurationSettings(describeConfigurationSettingsRequest);
            }
        });
    }

    @Override
    public Future<DescribeConfigurationSettingsResult> describeConfigurationSettingsAsync(final DescribeConfigurationSettingsRequest describeConfigurationSettingsRequest, final AsyncHandler<DescribeConfigurationSettingsRequest, DescribeConfigurationSettingsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConfigurationSettingsResult>(){

            @Override
            public DescribeConfigurationSettingsResult call() throws Exception {
                DescribeConfigurationSettingsResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.describeConfigurationSettings(describeConfigurationSettingsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeConfigurationSettingsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeApplicationsResult> describeApplicationsAsync(final DescribeApplicationsRequest describeApplicationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeApplicationsResult>(){

            @Override
            public DescribeApplicationsResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.describeApplications(describeApplicationsRequest);
            }
        });
    }

    @Override
    public Future<DescribeApplicationsResult> describeApplicationsAsync(final DescribeApplicationsRequest describeApplicationsRequest, final AsyncHandler<DescribeApplicationsRequest, DescribeApplicationsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeApplicationsResult>(){

            @Override
            public DescribeApplicationsResult call() throws Exception {
                DescribeApplicationsResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.describeApplications(describeApplicationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeApplicationsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> rebuildEnvironmentAsync(final RebuildEnvironmentRequest rebuildEnvironmentRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSElasticBeanstalkAsyncClient.this.rebuildEnvironment(rebuildEnvironmentRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> rebuildEnvironmentAsync(final RebuildEnvironmentRequest rebuildEnvironmentRequest, final AsyncHandler<RebuildEnvironmentRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSElasticBeanstalkAsyncClient.this.rebuildEnvironment(rebuildEnvironmentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(rebuildEnvironmentRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest describeEventsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                return AWSElasticBeanstalkAsyncClient.this.describeEvents(describeEventsRequest);
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest describeEventsRequest, final AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                DescribeEventsResult result;
                try {
                    result = AWSElasticBeanstalkAsyncClient.this.describeEvents(describeEventsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeEventsRequest, result);
                return result;
            }
        });
    }
}

