/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.domain.util;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.DataContainerStreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GzipDataContainer
implements DataContainer {
    private static final Log log = LogFactory.getLog(GzipDataContainer.class);
    private final DataContainer decorated;
    private DataContainerStreamUtil.CompressedOutputStream compressedOut;
    private int uncompressedSize;

    public GzipDataContainer(DataContainer decorated) {
        this.decorated = decorated;
    }

    public GzipDataContainer(DataContainer decorated, int uncompressedSize) {
        this(decorated);
        this.uncompressedSize = uncompressedSize;
    }

    @Override
    public boolean hasData() {
        return this.decorated.hasData();
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.compressedOut == null) {
            OutputStream out = this.decorated.getOutputStream();
            try {
                this.compressedOut = new DataContainerStreamUtil.CompressedOutputStream(out){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        GzipDataContainer.this.uncompressedSize = this.getUncompressedSize();
                    }
                };
                return this.compressedOut;
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
        }
        return this.compressedOut;
    }

    @Override
    public int dataSize() {
        return this.uncompressedSize;
    }

    @Override
    public InputStream getInputStream() {
        InputStream in = this.decorated.getInputStream();
        if (in == null) {
            return null;
        }
        try {
            return new GZIPInputStream(in);
        }
        catch (IOException e) {
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    @Override
    public byte[] getData() {
        return DataContainerStreamUtil.readDataAndClose(this.getInputStream());
    }

    public DataContainer getDecorated() {
        return this.decorated;
    }

    @Override
    public void dispose() {
        block3: {
            if (this.compressedOut != null) {
                try {
                    this.compressedOut.close();
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"Failed to close output stream", (Throwable)e);
                }
            }
        }
        this.decorated.dispose();
    }
}

