/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.crypto;

import com.jaspersoft.jasperserver.crypto.CryptoUtil;
import com.jaspersoft.jasperserver.crypto.EncryptionProperties;
import com.jaspersoft.jasperserver.crypto.KeystoreManager;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EncryptionEngine {
    private static final Logger a = LogManager.getLogger(EncryptionEngine.class);
    private static SecureRandom a;
    public static final String ENCRYPTION_PREFIX = "ENC-";
    public static final String ENCRYPTION_SUFFIX = "-";

    public static String encrypt(Key key, String string) {
        KeystoreManager keystoreManager = KeystoreManager.getInstance();
        return EncryptionEngine.encrypt(key, string, new EncryptionProperties(keystoreManager.getDefaultEncBlockSize(), keystoreManager.getDefaultEncTranformation()));
    }

    public static String encrypt(Key key, String string, EncryptionProperties encryptionProperties) {
        try {
            if (EncryptionEngine.isEncrypted(string)) {
                a.warn((Object)"Encrypt method received a value already marked encrypted. Returning the value without encryption.");
                return string;
            }
            Cipher cipher = Cipher.getInstance(encryptionProperties.getCipherTransformation());
            byte[] byArray = new byte[encryptionProperties.getBlockSize()];
            if (a == null) {
                a = new SecureRandom(SecureRandom.getSeed(32));
            }
            a.nextBytes(byArray);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            cipher.init(1, key, ivParameterSpec);
            byte[] byArray2 = cipher.doFinal(string.getBytes("UTF-8"));
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + byArray2.length);
            byteBuffer.put(byArray);
            byteBuffer.put(byArray2);
            return ENCRYPTION_PREFIX + CryptoUtil.printByteArrAsHexString(byteBuffer.array()) + ENCRYPTION_SUFFIX;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to encrypt", exception);
        }
    }

    public static String decrypt(Key key, String string) {
        KeystoreManager keystoreManager = KeystoreManager.getInstance();
        return EncryptionEngine.decrypt(key, string, new EncryptionProperties(keystoreManager.getDefaultEncBlockSize(), keystoreManager.getDefaultEncTranformation()));
    }

    public static String decrypt(Key key, String string, EncryptionProperties encryptionProperties) {
        try {
            if (!EncryptionEngine.isEncrypted(string)) {
                return string;
            }
            string = string.trim().replaceFirst(ENCRYPTION_PREFIX, "").replaceAll("-$", "");
            int n = encryptionProperties.getBlockSize();
            if (string.length() % (n * 2) != 0) {
                throw new RuntimeException("Cipher text is invalid.");
            }
            byte[] byArray = CryptoUtil.convertStringToByteArray(string);
            Cipher cipher = Cipher.getInstance(encryptionProperties.getCipherTransformation());
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[byArray.length - n];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n);
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray, n, byArray3.length);
            byteBuffer.get(byArray2);
            byteBuffer2.get(byArray3);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            cipher.init(2, key, ivParameterSpec);
            return new String(cipher.doFinal(byArray3), "UTF-8");
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to decrypt", exception);
        }
    }

    public static boolean isEncrypted(String string) {
        return (string = string.trim()).startsWith(ENCRYPTION_PREFIX) && string.endsWith(ENCRYPTION_SUFFIX);
    }
}

