/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.logging.diagnostic.datasource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.commons.lang.StringEscapeUtils;

public class DiagnosticCustomDataSource
implements JRDataSource {
    private List<List<Object>> data;
    private int index = -1;

    public DiagnosticCustomDataSource(List<List<Object>> data) {
        this.data = data;
    }

    public boolean next() throws JRException {
        ++this.index;
        return this.index < this.data.size();
    }

    public Object getFieldValue(JRField field) throws JRException {
        List<String> value = null;
        String fieldName = field.getName();
        if ("Section".equals(fieldName)) {
            value = this.data.get(this.index).get(0);
        } else if ("Attribute".equals(fieldName)) {
            value = this.data.get(this.index).get(1);
        } else if ("Value".equals(fieldName)) {
            Object attributeValue = this.data.get(this.index).get(2);
            if (attributeValue instanceof Map) {
                value = this.transformToList((Map)attributeValue);
            } else if (attributeValue instanceof List) {
                List<String> list = this.createOverrideList();
                list.addAll((List)attributeValue);
                value = list;
            } else {
                List<String> list = this.createOverrideList();
                if (attributeValue != null) {
                    list.add(attributeValue.toString());
                    value = list;
                } else {
                    list.add("");
                    value = list;
                }
            }
        } else if ("Description".equals(fieldName)) {
            value = this.data.get(this.index).get(3);
        }
        return value;
    }

    List<String> transformToList(Map<String, Object> map) {
        List<String> list = this.createOverrideList();
        if (map != null && map.keySet().size() > 0) {
            for (String key : map.keySet()) {
                if (map.get(key) != null) {
                    list.add(key + " = " + map.get(key).toString());
                    continue;
                }
                list.add(key + " = " + "");
            }
        }
        return list;
    }

    private List<String> createOverrideList() {
        return new ArrayList<String>(){

            @Override
            public String toString() {
                StringBuilder sb = new StringBuilder();
                if (this.size() == 1) {
                    sb.append((String)this.get(0));
                    return sb.toString();
                }
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    String element = (String)iterator.next();
                    sb.append(StringEscapeUtils.escapeJava((String)element));
                    if (!iterator.hasNext()) continue;
                    sb.append("\n");
                }
                return sb.toString();
            }
        };
    }
}

