/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.logging.diagnostic.service.impl;

import com.jaspersoft.jasperserver.api.logging.diagnostic.domain.DiagnosticAttribute;
import com.jaspersoft.jasperserver.api.logging.diagnostic.jmx.DiagnosticDynamicMBean;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.Diagnostic;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.DiagnosticCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;

public class DiagnosticDataProvider {
    Map<String, Diagnostic> diagnosticDataMap;
    private static final Log log = LogFactory.getLog(DiagnosticDataProvider.class);
    private static MessageSource messageSource;

    public void setDiagnosticDataMap(Map<String, Diagnostic> diagnosticDataMap) {
        this.diagnosticDataMap = diagnosticDataMap;
    }

    public List<List<Object>> getDiagnosticAttributesList() {
        log.debug((Object)"STARTING COLLECTION OF DIAGNOSTIC ATTRIBUTES");
        Long globalStartTime = System.currentTimeMillis();
        LinkedList<Object> diagnosticAttributeList = null;
        LinkedList<List<Object>> diagnosticAttributesList = new LinkedList<List<Object>>();
        for (String diagnosticSection : this.diagnosticDataMap.keySet()) {
            Map diagnosticData = this.diagnosticDataMap.get(diagnosticSection).getDiagnosticData();
            ArrayList sortedDiagnosticAttributes = new ArrayList(diagnosticData.keySet());
            Collections.sort(sortedDiagnosticAttributes, new DiagnosticDynamicMBean.DiagnosticComparator());
            for (DiagnosticAttribute diagnosticAttribute : sortedDiagnosticAttributes) {
                diagnosticAttributeList = new LinkedList<Object>();
                diagnosticAttributeList.add(this.parseSection(diagnosticSection));
                diagnosticAttributeList.add(diagnosticAttribute.getAttributeName());
                Long startTime = System.currentTimeMillis();
                Object diagnosticAttributeValue = ((DiagnosticCallback)diagnosticData.get(diagnosticAttribute)).getDiagnosticAttributeValue();
                Long executionTime = System.currentTimeMillis() - startTime;
                log.debug((Object)("Extracting " + diagnosticAttribute.getAttributeName() + "=" + executionTime));
                if (diagnosticAttributeValue != null) {
                    diagnosticAttributeList.add(diagnosticAttributeValue);
                } else {
                    diagnosticAttributeList.add("");
                }
                diagnosticAttributeList.add(messageSource.getMessage("diagnosticAttribute.desc." + diagnosticAttribute.getAttributeName(), new Object[0], Locale.getDefault()));
                diagnosticAttributesList.add(diagnosticAttributeList);
            }
        }
        log.debug((Object)"FINISHED COLLECTING DIAGNOSTIC ATTRIBUTES");
        Long globalExecutionTime = System.currentTimeMillis() - globalStartTime;
        log.debug((Object)("TOTAL TIME COLLECTING ATTRIBUTES = " + globalExecutionTime));
        return diagnosticAttributesList;
    }

    private String parseSection(String section) {
        String[] separation = section.split("=");
        if (separation.length == 2) {
            return separation[1];
        }
        return section;
    }

    public static void setMessageSource(MessageSource messageSource) {
        DiagnosticDataProvider.messageSource = messageSource;
    }
}

