/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl;

import com.jaspersoft.jasperserver.api.metadata.common.service.impl.Cipherer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.security.providers.encoding.PasswordEncoder;

public class PasswordCipherer
implements PasswordEncoder {
    private static Log log = LogFactory.getLog(PasswordCipherer.class);
    private static PasswordCipherer instance = null;
    private static Cipherer cipherer = null;
    private boolean allowEncoding = false;
    private boolean keyInPlainText = false;
    private String secretKey = null;
    private String secretKeyAlgorithm = null;
    private String cipherTransformation = null;

    public PasswordCipherer() {
        instance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static PasswordCipherer getInstance() {
        if (instance == null) {
            Class<PasswordCipherer> clazz = PasswordCipherer.class;
            // MONITORENTER : com.jaspersoft.jasperserver.api.metadata.common.service.impl.PasswordCipherer.class
            if (instance == null) {
                instance = new PasswordCipherer();
            }
            // MONITOREXIT : clazz
        }
        if (cipherer != null) return instance;
        if (!instance.isAllowEncoding()) return instance;
        instance.initCipherer();
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCipherer() {
        Class<PasswordCipherer> clazz = PasswordCipherer.class;
        synchronized (PasswordCipherer.class) {
            if (cipherer == null) {
                cipherer = new Cipherer();
                if (this.secretKey != null) {
                    cipherer.setKeyBytes(this.secretKey, this.keyInPlainText);
                }
                if (this.cipherTransformation != null) {
                    cipherer.setCipherTransformation(this.cipherTransformation);
                }
                if (this.secretKeyAlgorithm != null) {
                    cipherer.setKeyAlgorithm(this.secretKeyAlgorithm);
                }
                cipherer.init();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String decodePassword(String encPass) {
        Class<PasswordCipherer> clazz = PasswordCipherer.class;
        synchronized (PasswordCipherer.class) {
            try {
                log.debug((Object)("Decode password: " + this.allowEncoding));
                if (!this.allowEncoding) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return encPass;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return cipherer.decode(encPass);
            }
            catch (Exception ex) {
                log.warn((Object)"Password decryption failed", (Throwable)ex);
                throw new DataAccessResourceFailureException(ex.getMessage(), ex.getCause());
            }
        }
    }

    public String encodePassword(String rawPass) throws DataAccessException {
        Class<PasswordCipherer> clazz = PasswordCipherer.class;
        synchronized (PasswordCipherer.class) {
            try {
                log.debug((Object)("Encode password: " + this.allowEncoding));
                if (!this.allowEncoding) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return rawPass;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return cipherer.encode(rawPass);
            }
            catch (Exception ex) {
                log.warn((Object)"Password decryption failed", (Throwable)ex);
                throw new DataAccessResourceFailureException(ex.getMessage(), ex.getCause());
            }
        }
    }

    public String encodePassword(String rawPass, Object salt) throws DataAccessException {
        return this.encodePassword(rawPass);
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) throws DataAccessException {
        return rawPass.equals(encPass);
    }

    public boolean isAllowEncoding() {
        return this.allowEncoding;
    }

    public void setAllowEncoding(boolean allowEncoding) {
        this.allowEncoding = allowEncoding;
    }

    public String getCipherTransformation() {
        return this.cipherTransformation;
    }

    public void setCipherTransformation(String cipherTransformation) {
        this.cipherTransformation = cipherTransformation;
    }

    public boolean isKeyInPlainText() {
        return this.keyInPlainText;
    }

    public void setKeyInPlainText(boolean keyInPlainText) {
        this.keyInPlainText = keyInPlainText;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSecretKeyAlgorithm() {
        return this.secretKeyAlgorithm;
    }

    public void setSecretKeyAlgorithm(String secretKeyAlgorithm) {
        this.secretKeyAlgorithm = secretKeyAlgorithm;
    }
}

