/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.data.snapshot.hibernate;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileBufferedDataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.DataContainerStreamUtil;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataSnapshotContentsPersistenceService;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataSnapshotSerializer;
import com.jaspersoft.jasperserver.api.metadata.data.snapshot.hibernate.PersistentDataSnapshotContents;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import net.sf.jasperreports.data.cache.DataSnapshot;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class HibernateDataSnapshotContentsService
extends HibernateDaoImpl
implements DataSnapshotContentsPersistenceService {
    private static final Log log = LogFactory.getLog(HibernateDataSnapshotContentsService.class);
    private DataSnapshotSerializer snapshotSerializer;

    @Transactional(propagation=Propagation.MANDATORY, readOnly=true)
    public DataSnapshot loadDataSnapshot(ExecutionContext context, final long id) {
        return (DataSnapshot)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<DataSnapshot>(){

            public DataSnapshot doInHibernate(Session session) throws HibernateException, SQLException {
                DataSnapshot snapshot;
                Blob dataBlob;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("loading data snapshot " + id));
                }
                if ((dataBlob = HibernateDataSnapshotContentsService.this.loadSnapshotDataBlob(id, session)) == null) {
                    return null;
                }
                InputStream dataStream = dataBlob.getBinaryStream();
                try {
                    snapshot = HibernateDataSnapshotContentsService.this.getSnapshotSerializer().readSnapshot(dataStream);
                }
                catch (IOException e) {
                    throw new JSExceptionWrapper("Failed to read data snapshot", (Exception)e);
                }
                finally {
                    try {
                        dataStream.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)("Failed to close blob stream for data snapshot " + id), (Throwable)e);
                    }
                }
                return snapshot;
            }
        });
    }

    @Transactional(propagation=Propagation.MANDATORY, readOnly=true)
    public DataContainer loadDataSnapshotData(ExecutionContext context, final long id) {
        return (DataContainer)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<DataContainer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public DataContainer doInHibernate(Session session) throws HibernateException, SQLException {
                FileBufferedDataContainer dataContainer;
                Blob dataBlob;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("loading snapshot data " + id));
                }
                if ((dataBlob = HibernateDataSnapshotContentsService.this.loadSnapshotDataBlob(id, session)) == null) {
                    return null;
                }
                InputStream dataStream = dataBlob.getBinaryStream();
                try {
                    dataContainer = new FileBufferedDataContainer();
                    OutputStream dataOut = dataContainer.getOutputStream();
                    try {
                        DataContainerStreamUtil.pipeData((InputStream)dataStream, (OutputStream)dataOut);
                    }
                    finally {
                        dataOut.close();
                    }
                }
                catch (IOException e) {
                    throw new JSExceptionWrapper("Failed to read data snapshot", (Exception)e);
                }
                finally {
                    try {
                        dataStream.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)("Failed to close blob stream for data snapshot " + id), (Throwable)e);
                    }
                }
                return dataContainer;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.MANDATORY, readOnly=false)
    public long saveDataSnapshot(ExecutionContext context, DataSnapshot snapshot) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"saving snapshot");
        }
        FileBufferedDataContainer dataContainer = new FileBufferedDataContainer();
        try {
            boolean closeOut = true;
            OutputStream out = dataContainer.getOutputStream();
            try {
                this.getSnapshotSerializer().writeSnapshot(snapshot, out);
                closeOut = false;
                out.close();
            }
            catch (IOException e) {
                throw new JSExceptionWrapper("Failed to serialize data snapshot", (Exception)e);
            }
            finally {
                if (closeOut) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Failed to close data container stream for data snapshot");
                    }
                }
            }
            long l = this.saveSnapshotData((DataContainer)dataContainer);
            return l;
        }
        finally {
            dataContainer.dispose();
        }
    }

    public long saveDataSnapshot(ExecutionContext context, DataContainer snapshotData) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"saving snapshot data");
        }
        return this.saveSnapshotData(snapshotData);
    }

    @Transactional(propagation=Propagation.MANDATORY, readOnly=false)
    public void deleteDataSnapshot(ExecutionContext context, final long id) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Void>(){

            public Void doInHibernate(Session session) throws HibernateException, SQLException {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("deleting snapshot data " + id));
                }
                int count = session.getNamedQuery("JIDataSnapshotContentsDeleteId").setLong("id", id).executeUpdate();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("deleted " + count + " records for snapshot " + id));
                }
                if (count > 1) {
                    throw new JSException("Deletion of data snapshot " + id + " removed " + count + " records");
                }
                return null;
            }
        });
    }

    public DataSnapshotSerializer getSnapshotSerializer() {
        return this.snapshotSerializer;
    }

    public void setSnapshotSerializer(DataSnapshotSerializer snapshotSerializer) {
        this.snapshotSerializer = snapshotSerializer;
    }

    protected Blob loadSnapshotDataBlob(long id, Session session) {
        PersistentDataSnapshotContents persistentSnapshot = (PersistentDataSnapshotContents)session.get(PersistentDataSnapshotContents.class, (Serializable)Long.valueOf(id));
        if (persistentSnapshot == null) {
            log.info((Object)("Data snapshot " + id + " not found"));
            return null;
        }
        Blob dataBlob = persistentSnapshot.getData();
        if (dataBlob == null) {
            log.warn((Object)("Data snapshot " + id + " is empty"));
            return null;
        }
        return dataBlob;
    }

    protected long saveSnapshotData(final DataContainer snapshotData) {
        return (Long)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Long>(){

            public Long doInHibernate(Session session) throws HibernateException, SQLException {
                Blob dataBlob;
                PersistentDataSnapshotContents persistentSnapshot = new PersistentDataSnapshotContents();
                try {
                    dataBlob = Hibernate.createBlob((InputStream)snapshotData.getInputStream());
                }
                catch (IOException e) {
                    throw new JSExceptionWrapper("Failed to create data snapshot blob", (Exception)e);
                }
                persistentSnapshot.setData(dataBlob);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"saving data snapshot to the DB");
                }
                session.save((Object)persistentSnapshot);
                session.flush();
                long savedId = persistentSnapshot.getId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("saved data snapshot " + savedId));
                }
                return savedId;
            }
        });
    }

    public Long copyDataSnapshot(long id) {
        DataContainer snapshotData;
        if (log.isDebugEnabled()) {
            log.debug((Object)("copying snapshot data " + id));
        }
        if ((snapshotData = this.loadDataSnapshotData(null, id)) == null && log.isDebugEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("data for snapshot contents " + id + " not found for copy"));
            }
            return null;
        }
        return this.saveSnapshotData(snapshotData);
    }
}

