/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client;

import com.jaspersoft.jasperserver.api.JasperServerAPI;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.TenantAwareGrantedAuthority;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.TenantQualifiedPrincipal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.UserDetails;

@JasperServerAPI
public class MetadataUserDetails
implements UserDetails,
User {
    private Set roleSet;
    private String username = null;
    private String password = null;
    private boolean enabled = false;
    private String fullName = null;
    private String emailAddress = null;
    private boolean externallyDefined = false;
    private Authentication originalAuthentication = null;
    private Date previousPasswordChangeTime = null;
    private List attributes = null;
    private String tenantId = null;

    public MetadataUserDetails(User u) {
        this.setUsername(u.getUsername());
        String password = u.isExternallyDefined() ? null : u.getPassword();
        this.setPassword(password);
        this.setFullName(u.getFullName());
        this.setEmailAddress(u.getEmailAddress());
        this.setExternallyDefined(u.isExternallyDefined());
        this.setEnabled(u.isEnabled());
        this.setRoles(u.getRoles());
        this.setAttributes(u.getAttributes());
        this.setTenantId(u.getTenantId());
    }

    public GrantedAuthority[] getAuthorities() {
        GrantedAuthority[] authorities;
        Set currentRoles = this.getRoles();
        GrantedAuthority[] grantedAuthorityArray = authorities = currentRoles == null ? new GrantedAuthority[]{} : new GrantedAuthority[currentRoles.size()];
        if (currentRoles == null) {
            return authorities;
        }
        Iterator it = currentRoles.iterator();
        int i = 0;
        while (it.hasNext()) {
            Role aRole = (Role)it.next();
            authorities[i++] = new TenantAwareGrantedAuthority(aRole.getRoleName(), aRole.getTenantId());
        }
        return authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public boolean isExternallyDefined() {
        return this.externallyDefined;
    }

    public void setExternallyDefined(boolean externallyDefined) {
        this.externallyDefined = externallyDefined;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public boolean isAccountNonExpired() {
        return this.enabled;
    }

    public boolean isAccountNonLocked() {
        return this.enabled;
    }

    public boolean isCredentialsNonExpired() {
        return this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Set getRoles() {
        return this.roleSet;
    }

    public void setRoles(Set newRoleSet) {
        this.roleSet = newRoleSet;
    }

    public Authentication getOriginalAuthentication() {
        return this.originalAuthentication;
    }

    public void setOriginalAuthentication(Authentication auth) {
        this.originalAuthentication = auth;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List attrs) {
        this.attributes = attrs;
    }

    public void addRole(Role aRole) {
    }

    public void removeRole(Role aRole) {
    }

    public String toString() {
        return "MetadataUserDetails: " + this.getUsername();
    }

    public Date getPreviousPasswordChangeTime() {
        return this.previousPasswordChangeTime;
    }

    public void setPreviousPasswordChangeTime(Date previousPasswordChangeTime) {
        this.previousPasswordChangeTime = previousPasswordChangeTime;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tid) {
        this.tenantId = tid;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TenantQualifiedPrincipal) {
            TenantQualifiedPrincipal principal = (TenantQualifiedPrincipal)obj;
            return this.username.equals(principal.getName()) && (this.tenantId == null ? principal.getTenantId() == null : this.tenantId.equals(principal.getTenantId()));
        }
        return super.equals(obj);
    }
}

