/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.js.ajax;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.js.ajax.AbstractAjaxHandler;
import org.springframework.util.StringUtils;

public class SpringJavascriptAjaxHandler
extends AbstractAjaxHandler {
    public static final String REDIRECT_URL_HEADER = "Spring-Redirect-URL";
    public static final String POPUP_VIEW_HEADER = "Spring-Modal-View";
    public static final String AJAX_ACCEPT_CONTENT_TYPE = "text/html;type=ajax";
    public static final String AJAX_SOURCE_PARAM = "ajaxSource";

    public SpringJavascriptAjaxHandler() {
        this(null);
    }

    public SpringJavascriptAjaxHandler(AbstractAjaxHandler delegate) {
        super(delegate);
    }

    protected boolean isAjaxRequestInternal(HttpServletRequest request, HttpServletResponse response) {
        String acceptHeader = request.getHeader("Accept");
        String ajaxParam = request.getParameter(AJAX_SOURCE_PARAM);
        return AJAX_ACCEPT_CONTENT_TYPE.equals(acceptHeader) || StringUtils.hasText((String)ajaxParam);
    }

    protected void sendAjaxRedirectInternal(String targetUrl, HttpServletRequest request, HttpServletResponse response, boolean popup) throws IOException {
        if (popup) {
            response.setHeader(POPUP_VIEW_HEADER, "true");
        }
        response.setHeader(REDIRECT_URL_HEADER, response.encodeRedirectURL(targetUrl));
    }
}

