/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.buildomatic.crypto;

import com.jaspersoft.jasperserver.crypto.EncryptionProperties;
import com.jaspersoft.jasperserver.crypto.KeystoreManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class KeystoreTask
extends Task {
    private String ks;
    private String ksp = ".jrsksp";
    private String propsFile = null;

    public void execute() throws BuildException {
        FileInputStream masterPropFis = null;
        try {
            if (this.propsFile == null) {
                throw new RuntimeException("Failed to find master properties file");
            }
            masterPropFis = new FileInputStream(this.propsFile);
            Properties masterProps = new Properties();
            masterProps.load(masterPropFis);
            Boolean encFlag = Boolean.parseBoolean(masterProps.getProperty("encrypt"));
            if (encFlag.booleanValue()) {
                KeystoreManager.init((String)this.ks, (String)this.ksp, (EncryptionProperties)new EncryptionProperties(new File(this.propsFile)));
            }
        }
        catch (Exception e) {
            this.log(e.getMessage(), 0);
            throw new BuildException("Keystore may have been tempered with.", (Throwable)e, this.getLocation());
        }
        finally {
            try {
                if (masterPropFis != null) {
                    masterPropFis.close();
                }
            }
            catch (IOException e) {
                this.log("Failed to close master prop: " + e, 0);
            }
        }
    }

    public String getKs() {
        return this.ks;
    }

    public void setKs(String directory) {
        this.ks = directory;
    }

    public String getKsp() {
        return this.ksp;
    }

    public void setKsp(String ksProp) {
        this.ksp = ksProp;
    }

    public String getPropsFile() {
        return this.propsFile;
    }

    public void setPropsFile(String propsFile) {
        this.propsFile = propsFile;
    }
}

