/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.crypto;

import com.jaspersoft.jasperserver.crypto.CryptoUtil;
import com.jaspersoft.jasperserver.crypto.EncryptionProperties;
import com.jaspersoft.jasperserver.crypto.KeystoreManager;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class EncryptionEngine {
    private static final Logger logger = LogManager.getLogger(EncryptionEngine.class);
    private static SecureRandom RANDOM_GENERATOR;
    public static final String ENCRYPTION_PREFIX = "ENC-";
    public static final String ENCRYPTION_SUFFIX = "-";

    public static String encrypt(Key key, String plainTxt) {
        KeystoreManager ksm = KeystoreManager.getInstance();
        return EncryptionEngine.encrypt(key, plainTxt, new EncryptionProperties(ksm.getDefaultEncBlockSize(), ksm.getDefaultEncTranformation()));
    }

    public static String encrypt(Key key, String plainTxt, EncryptionProperties encProps) {
        try {
            if (EncryptionEngine.isEncrypted(plainTxt)) {
                logger.warn((Object)"Encrypt method received a value already marked encrypted. Returning the value without encryption.");
                return plainTxt;
            }
            Cipher encryptor = Cipher.getInstance(encProps.getCipherTransformation());
            byte[] ivBytes = new byte[encProps.getBlockSize()];
            if (RANDOM_GENERATOR == null) {
                RANDOM_GENERATOR = new SecureRandom(SecureRandom.getSeed(32));
            }
            RANDOM_GENERATOR.nextBytes(ivBytes);
            IvParameterSpec paramSpec = new IvParameterSpec(ivBytes);
            encryptor.init(1, key, paramSpec);
            byte[] partCT = encryptor.doFinal(plainTxt.getBytes("UTF-8"));
            ByteBuffer bb = ByteBuffer.allocate(ivBytes.length + partCT.length);
            bb.put(ivBytes);
            bb.put(partCT);
            return ENCRYPTION_PREFIX + CryptoUtil.printByteArrAsHexString(bb.array()) + ENCRYPTION_SUFFIX;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to encrypt", e);
        }
    }

    public static String decrypt(Key key, String cipherTxt) {
        KeystoreManager ksm = KeystoreManager.getInstance();
        return EncryptionEngine.decrypt(key, cipherTxt, new EncryptionProperties(ksm.getDefaultEncBlockSize(), ksm.getDefaultEncTranformation()));
    }

    public static String decrypt(Key key, String cipherTxt, EncryptionProperties encProps) {
        try {
            if (!EncryptionEngine.isEncrypted(cipherTxt)) {
                return cipherTxt;
            }
            cipherTxt = cipherTxt.trim().replaceFirst(ENCRYPTION_PREFIX, "").replaceAll("-$", "");
            int blockSize = encProps.getBlockSize();
            if (cipherTxt.length() % (blockSize * 2) != 0) {
                throw new RuntimeException("Cipher text is invalid.");
            }
            byte[] cipherByteArr = CryptoUtil.convertStringToByteArray(cipherTxt);
            Cipher encrypter = Cipher.getInstance(encProps.getCipherTransformation());
            byte[] ivBytes = new byte[blockSize];
            byte[] ctBytes = new byte[cipherByteArr.length - blockSize];
            ByteBuffer bbIV = ByteBuffer.wrap(cipherByteArr, 0, blockSize);
            ByteBuffer bbCT = ByteBuffer.wrap(cipherByteArr, blockSize, ctBytes.length);
            bbIV.get(ivBytes);
            bbCT.get(ctBytes);
            IvParameterSpec paramSpec = new IvParameterSpec(ivBytes);
            encrypter.init(2, key, paramSpec);
            return new String(encrypter.doFinal(ctBytes), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to decrypt", e);
        }
    }

    public static boolean isEncrypted(String str) {
        if (str == null) {
            return false;
        }
        return (str = str.trim()).startsWith(ENCRYPTION_PREFIX) && str.endsWith(ENCRYPTION_SUFFIX);
    }
}

