/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository.beans;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.AwsReportDataSource;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.beans.JdbcDataSourceBean;

public class AwsDataSourceBean
extends JdbcDataSourceBean {
    private String accessKey;
    private String secretKey;
    private String roleARN;
    private String region;
    private String dbName;
    private String dbInstanceIdentifier;
    private String dbService;

    @Override
    protected void additionalCopyFrom(Resource res, ResourceExportHandler referenceHandler) {
        super.additionalCopyFrom(res, referenceHandler);
        AwsReportDataSource ds = (AwsReportDataSource)res;
        this.setAccessKey("ENC<" + importExportCipher.encode(ds.getAWSAccessKey()) + ">");
        this.setSecretKey("ENC<" + importExportCipher.encode(ds.getAWSSecretKey()) + ">");
        this.setRoleARN(ds.getRoleARN());
        this.setRegion(ds.getAWSRegion());
        this.setDbName(ds.getDbName());
        this.setDbService(ds.getDbService());
        this.setDbInstanceIdentifier(ds.getDbInstanceIdentifier());
    }

    @Override
    protected void additionalCopyTo(Resource res, ResourceImportHandler importHandler) {
        super.additionalCopyTo(res, importHandler);
        AwsReportDataSource ds = (AwsReportDataSource)res;
        ds.setRoleARN(this.getRoleARN());
        ds.setAWSRegion(this.getRegion());
        ds.setDbName(this.getDbName());
        ds.setDbService(this.getDbService());
        ds.setDbInstanceIdentifier(this.getDbInstanceIdentifier());
        String accKey = this.getAccessKey();
        String secKey = this.getSecretKey();
        ds.setAWSAccessKey(accKey != null && accKey.startsWith("ENC<") && accKey.endsWith(">") ? importExportCipher.decode(accKey.replaceFirst("ENC<", "").replaceAll(">$", "")) : accKey);
        ds.setAWSSecretKey(secKey != null && secKey.startsWith("ENC<") && secKey.endsWith(">") ? importExportCipher.decode(secKey.replaceFirst("ENC<", "").replaceAll(">$", "")) : secKey);
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRoleARN() {
        return this.roleARN;
    }

    public void setRoleARN(String roleARN) {
        this.roleARN = roleARN;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public void setDbInstanceIdentifier(String dbInstanceIdentifier) {
        this.dbInstanceIdentifier = dbInstanceIdentifier;
    }

    public String getDbService() {
        return this.dbService;
    }

    public void setDbService(String dbService) {
        this.dbService = dbService;
    }
}

