/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.scheduling;

import com.jaspersoft.jasperserver.export.modules.BaseExporterModule;
import com.jaspersoft.jasperserver.export.modules.scheduling.SchedulingModuleConfiguration;
import com.jaspersoft.jasperserver.export.modules.scheduling.beans.HolidayCalendarBean;
import com.jaspersoft.jasperserver.export.util.PathUtils;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.quartz.Calendar;
import org.quartz.impl.calendar.HolidayCalendar;

public class CalendarsExporter
extends BaseExporterModule {
    protected static final Pattern RESOURCE_ID_INVALID_CHAR = Pattern.compile("[^\\p{L}\\p{N}]");
    protected static final String RESOURCE_ID_CHAR_REPLACEMENT = "_";
    protected SchedulingModuleConfiguration configuration;
    protected String calendarsArg;

    @Override
    protected boolean isToProcess() {
        return this.hasParameter(this.calendarsArg);
    }

    @Override
    public void process() {
        List calendarNames = this.configuration.getReportJobsScheduler().getCalendarNames();
        if (CollectionUtils.isNotEmpty((Collection)calendarNames)) {
            this.mkdir(this.configuration.getCalendarsDir());
            for (String name : calendarNames) {
                this.processCalendar(name);
            }
        }
    }

    private void processCalendar(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return;
        }
        Calendar calendar = this.configuration.getReportJobsScheduler().getCalendar(name);
        if (calendar == null) {
            return;
        }
        if (calendar instanceof HolidayCalendar) {
            this.exportCalendar(this.configuration.getCalendarsDir(), name, (HolidayCalendar)calendar);
            this.addIndexElement(name);
            commandOut.info(this.calendarExportInfo(name));
        } else {
            commandOut.debug(this.calendarExportOmit(name));
        }
    }

    protected void exportCalendar(String folderPath, String name, HolidayCalendar calendar) {
        HolidayCalendarBean calendarBean = new HolidayCalendarBean();
        calendarBean.setName(name);
        calendarBean.copyFrom(calendar);
        this.serialize(calendarBean, folderPath, this.getFilename(name), this.configuration.getSerializer());
    }

    protected Element addIndexElement(String calendarName) {
        Element roleElement = this.getIndexElement().addElement(this.configuration.getIndexCalendarElement());
        roleElement.setText(calendarName);
        return roleElement;
    }

    protected String getFilename(String name) {
        return PathUtils.preparePathComponent(name) + ".xml";
    }

    private String calendarExportInfo(String name) {
        StringBuilder info = new StringBuilder("Exported ").append(name).append(" holiday calendar.");
        return info.toString();
    }

    private String calendarExportOmit(String name) {
        StringBuilder info = new StringBuilder("Calendar ").append(name).append(" does not exported.");
        return info.toString();
    }

    public SchedulingModuleConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SchedulingModuleConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getCalendarsArg() {
        return this.calendarsArg;
    }

    public void setCalendarsArg(String calendarsArg) {
        this.calendarsArg = calendarsArg;
    }
}

