/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathUtils {
    public static final char FILE_SEPARATOR = '/';
    protected static final Pattern MULTI_FILE_SEP_PATTERN = Pattern.compile("/{2,}");
    protected static final String MULTI_FILE_SEP_REPLACEMENT = "/";
    protected static final Pattern SPLIT_URI_PATTERN = Pattern.compile("^(.*)/([^/]+)/*$");
    protected static final int SPLIT_URI_PATTERN_PARENT_IDX = 1;
    protected static final int SPLIT_URI_PATTERN_NAME_IDX = 2;
    protected static final Pattern PATH_COMPONENT_INVALID_CHAR = Pattern.compile("[^\\p{L}\\p{N}]");
    protected static final String PATH_COMPONENT_CHAR_REPLACEMENT = "_";

    public static SplittedPath splitPath(String uri) {
        SplittedPath splUri;
        Matcher matcher = SPLIT_URI_PATTERN.matcher(uri);
        if (matcher.matches()) {
            String parentURI = matcher.group(1);
            if (parentURI.length() == 0) {
                parentURI = null;
            }
            String name = matcher.group(2);
            splUri = new SplittedPath(parentURI, name);
        } else {
            splUri = null;
        }
        return splUri;
    }

    public static String concatPaths(String path1, String path2) {
        if (path1 == null) {
            if (path2 == null) {
                return null;
            }
            return PathUtils.normalizePath(path2);
        }
        if (path2 == null) {
            return PathUtils.normalizePath(path1);
        }
        return PathUtils.normalizePath(path1 + '/' + path2);
    }

    public static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        if ((path = MULTI_FILE_SEP_PATTERN.matcher(path).replaceAll(MULTI_FILE_SEP_REPLACEMENT)).length() > 1 && path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String preparePathComponent(String name) {
        return PATH_COMPONENT_INVALID_CHAR.matcher(name).replaceAll(PATH_COMPONENT_CHAR_REPLACEMENT);
    }

    public static class SplittedPath {
        public final String parentPath;
        public final String name;

        public SplittedPath(String parentPath, String name) {
            this.parentPath = parentPath;
            this.name = name;
        }
    }
}

