/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.sample.controller;

import com.jaspersoft.jasperserver.sample.controller.WSServlet;
import com.jaspersoft.jasperserver.sample.controller.vo.PermissionVO;
import com.jaspersoft.jasperserver.sample.controller.vo.RoleVO;
import com.jaspersoft.jasperserver.sample.controller.vo.UserVO;
import com.jaspersoft.jasperserver.ws.authority.WSObjectPermission;
import com.jaspersoft.jasperserver.ws.authority.WSRole;
import com.jaspersoft.jasperserver.ws.authority.WSRoleSearchCriteria;
import com.jaspersoft.jasperserver.ws.authority.WSUser;
import com.jaspersoft.jasperserver.ws.authority.WSUserSearchCriteria;
import com.jaspersoft.jasperserver.ws.client.authority.PermissionsManagement;
import com.jaspersoft.jasperserver.ws.client.authority.UserAndRoleManagement;
import com.jaspersoft.jasperserver.ws.client.controller.WSClientManager;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.ServiceException;

public class PermissionsServlet
extends WSServlet {
    protected static final String SEPARATOR = "/";
    protected static final int NO_PERMISSION_SET = -1;
    protected static final int INHERITED = 256;
    protected static final String PERMISSION_PARM = "permission_";
    protected static final String PREV_PERMISSION_PARM = "prev_permission_";
    protected static final int NO_ACCESS = 0;
    protected static final String PROTOCOL = "repo:";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resourceUri = request.getParameter("resourceUri");
        request.setAttribute("resourceUri", (Object)resourceUri);
        String show = request.getParameter("show");
        request.setAttribute("show", (Object)show);
        String ok = request.getParameter("ok");
        String cancel = request.getParameter("cancel");
        if (ok != null) {
            if (show.equals("byUser")) {
                try {
                    this.setUserPermissions(request, resourceUri);
                }
                catch (ServiceException e) {
                    throw new ServletException((Throwable)e);
                }
            } else if (show.equals("byRole")) {
                try {
                    this.setRolePermissions(request, resourceUri);
                }
                catch (ServiceException e) {
                    throw new ServletException((Throwable)e);
                }
            } else {
                throw new RuntimeException("Unknown mode '" + show + "'");
            }
            this.prepareDataAndForward(request, response, resourceUri, show);
        } else if (cancel != null) {
            response.sendRedirect("../listReports.jsp");
        } else {
            this.prepareDataAndForward(request, response, resourceUri, show);
        }
    }

    private void prepareDataAndForward(HttpServletRequest request, HttpServletResponse response, String resourceUri, String show) throws IOException, ServletException {
        try {
            PermissionsManagement permissionsManagement = WSClientManager.getPermissionsManagement((String)this.getBaseAddress(request));
            WSObjectPermission[] wsObjectPermissions = permissionsManagement.getPermissionsForObject(this.getAddressWithProtocol(resourceUri));
            if (show.equals("byUser")) {
                Map<String, WSObjectPermission> userPermissionMap = this.getUserPermissionsMap(wsObjectPermissions);
                WSUser[] users = this.getUsers(request);
                List<UserVO> userVOs = this.getUserVOs(request, resourceUri, users, userPermissionMap);
                request.setAttribute("users", userVOs);
            } else if (show.equals("byRole")) {
                Map<String, WSObjectPermission> rolePermissionMap = this.getRolePermissionsMap(wsObjectPermissions);
                WSRole[] roles = this.getRoles(request);
                List<RoleVO> roleVOs = this.getRoleVOs(request, resourceUri, roles, rolePermissionMap);
                request.setAttribute("roles", roleVOs);
            }
            this.forward("authority/permissions.jsp", request, response);
        }
        catch (ServiceException e) {
            this.forwardError((Exception)((Object)e), request, response);
        }
    }

    private void setRolePermissions(HttpServletRequest request, String resourceUri) throws ServiceException, RemoteException {
        Map<String, Integer> permissionMap = this.getPermissionMap(request);
        if (permissionMap.size() > 0) {
            for (Map.Entry<String, Integer> entry : permissionMap.entrySet()) {
                String roleName = entry.getKey();
                int permissionMask = entry.getValue();
                int prevPermissionMask = this.getPreviousPermissionMask(roleName, request);
                WSRole role = this.getRole(request, roleName);
                this.setPermission(request, resourceUri, permissionMask, prevPermissionMask, role);
            }
        }
    }

    private void setPermission(HttpServletRequest request, String resourceUri, int permissionMask, int prevPermissionMask, Object recipient) throws ServiceException, RemoteException {
        if (prevPermissionMask != permissionMask) {
            PermissionsManagement permissionsManagement = WSClientManager.getPermissionsManagement((String)this.getBaseAddress(request));
            WSObjectPermission permission = new WSObjectPermission();
            permission.setPermissionRecipient(recipient);
            permission.setUri(this.getAddressWithProtocol(resourceUri));
            permission.setPermissionMask(permissionMask);
            if (permissionMask <= 255) {
                int upChainPermission = this.goUpFolderChainToGetPermission(request, resourceUri, recipient);
                if (permissionMask == 0) {
                    if (upChainPermission == 0) {
                        permissionsManagement.deletePermission(permission);
                    } else {
                        permissionsManagement.putPermission(permission);
                    }
                } else if (upChainPermission == permissionMask << 9) {
                    permissionsManagement.deletePermission(permission);
                } else {
                    permissionsManagement.putPermission(permission);
                }
            } else {
                permission.setPermissionMask(permissionMask /= 512);
                permissionsManagement.putPermission(permission);
            }
        }
    }

    protected WSRole getRole(HttpServletRequest request, String roleName) throws RemoteException, ServiceException {
        WSRoleSearchCriteria searchCriteria = new WSRoleSearchCriteria(roleName, null, Boolean.valueOf(false), 0);
        WSRole[] roles = WSClientManager.getUserAndRoleManagement((String)this.getBaseAddress(request)).findRoles(searchCriteria);
        if (roles == null || roles.length == 0 || roles.length > 1) {
            throw new RuntimeException("Problems to find role with role name '" + roleName + "'");
        }
        return roles[0];
    }

    protected WSUser getUser(HttpServletRequest request, String userName) throws RemoteException, ServiceException {
        WSUserSearchCriteria searchCriteria = new WSUserSearchCriteria(userName, null, Boolean.valueOf(false), null, 0);
        WSUser[] users = WSClientManager.getUserAndRoleManagement((String)this.getBaseAddress(request)).findUsers(searchCriteria);
        if (users == null || users.length == 0 || users.length > 1) {
            throw new RuntimeException("Problems to find role with role name '" + userName + "'");
        }
        return users[0];
    }

    private void setUserPermissions(HttpServletRequest request, String resourceUri) throws ServiceException, RemoteException {
        Map<String, Integer> permissionMap = this.getPermissionMap(request);
        if (permissionMap.size() > 0) {
            for (Map.Entry<String, Integer> entry : permissionMap.entrySet()) {
                String userName = entry.getKey();
                int permissionMask = entry.getValue();
                int prevPermissionMask = this.getPreviousPermissionMask(userName, request);
                WSUser user = this.getUser(request, userName);
                this.setPermission(request, resourceUri, permissionMask, prevPermissionMask, user);
            }
        }
    }

    private Map<String, Integer> getPermissionMap(HttpServletRequest request) {
        HashMap<String, Integer> permissionMap = new HashMap<String, Integer>(request.getParameterMap().size());
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            if (!((String)entry.getKey()).startsWith(PERMISSION_PARM)) continue;
            String name = ((String)entry.getKey()).substring(PERMISSION_PARM.length());
            int permissionMask = Integer.parseInt(((String[])entry.getValue())[0]);
            permissionMap.put(name, permissionMask);
        }
        return permissionMap;
    }

    protected int getPreviousPermissionMask(String name, HttpServletRequest request) {
        return Integer.parseInt(request.getParameter(PREV_PERMISSION_PARM + name));
    }

    private List<UserVO> getUserVOs(HttpServletRequest request, String resourceUri, WSUser[] users, Map<String, WSObjectPermission> permissionMap) throws ServiceException, RemoteException {
        ArrayList<UserVO> userVOs = new ArrayList<UserVO>(users.length);
        for (WSUser user : users) {
            PermissionVO permissionVO = this.getPermissionVO(request, resourceUri, permissionMap.get(this.getUserKey(user)), user);
            userVOs.add(this.getUserVO(user, permissionVO));
        }
        return userVOs;
    }

    protected UserVO getUserVO(WSUser user, PermissionVO permissionVO) {
        UserVO userVO = new UserVO();
        userVO.setUser(user);
        userVO.setPermission(permissionVO);
        return userVO;
    }

    private List<RoleVO> getRoleVOs(HttpServletRequest request, String resourceUri, WSRole[] roles, Map<String, WSObjectPermission> permissionMap) throws ServiceException, RemoteException {
        ArrayList<RoleVO> roleVOs = new ArrayList<RoleVO>(roles.length);
        for (WSRole role : roles) {
            PermissionVO permissionVO = this.getPermissionVO(request, resourceUri, permissionMap.get(this.getRoleKey(role)), role);
            RoleVO roleVO = this.getRoleVO(role, permissionVO);
            roleVOs.add(roleVO);
        }
        return roleVOs;
    }

    protected RoleVO getRoleVO(WSRole role, PermissionVO permissionVO) {
        RoleVO roleVO = new RoleVO();
        roleVO.setRole(role);
        roleVO.setPermission(permissionVO);
        return roleVO;
    }

    private PermissionVO getPermissionVO(HttpServletRequest request, String resourceUri, WSObjectPermission permission, Object recipient) throws RemoteException, ServiceException {
        int permissionToDisplay = -1;
        if (permission != null && permission.getPermissionRecipient() != null) {
            permissionToDisplay = permission.getPermissionMask() + this.goUpFolderChainToGetPermission(request, resourceUri, recipient);
        }
        if (permissionToDisplay == -1) {
            permissionToDisplay = this.goUpFolderChainToGetPermission(request, resourceUri, recipient) + 256;
        }
        PermissionVO permissionVO = new PermissionVO();
        permissionVO.setPermission(permission);
        permissionVO.setPermissionToDisplay(permissionToDisplay);
        return permissionVO;
    }

    private Map<String, WSObjectPermission> getUserPermissionsMap(WSObjectPermission[] permissions) {
        HashMap<String, WSObjectPermission> permissionMap = new HashMap<String, WSObjectPermission>(permissions.length);
        for (WSObjectPermission wsObjectPermission : permissions) {
            if (!(wsObjectPermission.getPermissionRecipient() instanceof WSUser)) continue;
            permissionMap.put(this.getUserKey((WSUser)wsObjectPermission.getPermissionRecipient()), wsObjectPermission);
        }
        return permissionMap;
    }

    private Map<String, WSObjectPermission> getRolePermissionsMap(WSObjectPermission[] permissions) {
        HashMap<String, WSObjectPermission> permissionMap = new HashMap<String, WSObjectPermission>(permissions.length);
        for (WSObjectPermission wsObjectPermission : permissions) {
            if (!(wsObjectPermission.getPermissionRecipient() instanceof WSRole)) continue;
            permissionMap.put(this.getRoleKey((WSRole)wsObjectPermission.getPermissionRecipient()), wsObjectPermission);
        }
        return permissionMap;
    }

    protected String getUserKey(WSUser user) {
        return user.getUsername();
    }

    protected String getRoleKey(WSRole role) {
        return role.getRoleName();
    }

    protected WSUser[] getUsers(HttpServletRequest request) throws ServiceException, RemoteException {
        UserAndRoleManagement userAndRoleManagement = WSClientManager.getUserAndRoleManagement((String)this.getBaseAddress(request));
        WSUserSearchCriteria searchCriteria = new WSUserSearchCriteria();
        searchCriteria.setName("");
        searchCriteria.setMaxRecords(0);
        searchCriteria.setIncludeSubOrgs(Boolean.TRUE);
        searchCriteria.setRequiredRoles(null);
        return userAndRoleManagement.findUsers(searchCriteria);
    }

    protected WSRole[] getRoles(HttpServletRequest request) throws ServiceException, RemoteException {
        UserAndRoleManagement userAndRoleManagement = WSClientManager.getUserAndRoleManagement((String)this.getBaseAddress(request));
        WSRoleSearchCriteria searchCriteria = new WSRoleSearchCriteria();
        searchCriteria.setRoleName("");
        searchCriteria.setMaxRecords(0);
        searchCriteria.setIncludeSubOrgs(Boolean.TRUE);
        return userAndRoleManagement.findRoles(searchCriteria);
    }

    private int goUpFolderChainToGetPermission(HttpServletRequest request, String resourceUri, Object recipient) throws ServiceException, RemoteException {
        int permission = this.getInheritedObjectPermissionMask(request, resourceUri, recipient);
        return permission << 9;
    }

    private int getInheritedObjectPermissionMask(HttpServletRequest request, String resourceUri, Object recipient) throws RemoteException, ServiceException {
        int permissionMask = 0;
        String folderUri = this.getParentUri(resourceUri);
        while (folderUri != null) {
            WSObjectPermission[] permissions = this.getObjectPermissions(request, folderUri);
            if (permissions != null && permissions.length > 0) {
                for (WSObjectPermission permission : permissions) {
                    if (recipient instanceof WSUser && permission.getPermissionRecipient() instanceof WSUser) {
                        WSUser user = (WSUser)recipient;
                        WSUser permissionUser = (WSUser)permission.getPermissionRecipient();
                        if (!user.getUsername().equals(permissionUser.getUsername())) continue;
                        permissionMask = permission.getPermissionMask();
                        break;
                    }
                    if (!(recipient instanceof WSRole) || !(permission.getPermissionRecipient() instanceof WSRole)) continue;
                    WSRole role = (WSRole)recipient;
                    WSRole permissionRole = (WSRole)permission.getPermissionRecipient();
                    if (!role.getRoleName().equals(permissionRole.getRoleName())) continue;
                    permissionMask = permission.getPermissionMask();
                    break;
                }
            }
            folderUri = this.getParentUri(folderUri);
        }
        return permissionMask;
    }

    private WSObjectPermission[] getObjectPermissions(HttpServletRequest request, String resourceUri) throws ServiceException, RemoteException {
        PermissionsManagement permissionsManagement = WSClientManager.getPermissionsManagement((String)this.getBaseAddress(request));
        return permissionsManagement.getPermissionsForObject(this.getAddressWithProtocol(resourceUri));
    }

    private String getAddressWithProtocol(String resourceUri) {
        resourceUri = resourceUri.startsWith(PROTOCOL) ? resourceUri : PROTOCOL + resourceUri;
        return resourceUri;
    }

    private String getParentUri(String resourceUri) {
        int lastSeparator = resourceUri.lastIndexOf(SEPARATOR);
        if (lastSeparator < 0) {
            return null;
        }
        if (lastSeparator == 0) {
            if (resourceUri.length() == 1) {
                return null;
            }
            return SEPARATOR;
        }
        return resourceUri.substring(0, lastSeparator);
    }
}

