/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.util.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.util.FTPService;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;

public class FTPUtil
implements FTPService {
    private static final Log log = LogFactory.getLog(FTPUtil.class);

    public FTPService.FTPServiceClient connect(String host, String userName, String password) throws Exception {
        return new FTPSServiceClientImpl(host, 990, "TLS", true, 0L, "P", userName, password);
    }

    public FTPService.FTPServiceClient connectFTP(String host, int port, String userName, String password) throws Exception {
        return new FTPServiceClientImpl(host, port, userName, password);
    }

    public FTPService.FTPServiceClient connectFTPS(String host, int port, String userName, String password) throws Exception {
        return new FTPSServiceClientImpl(host, port, "TLS", true, 0L, "P", userName, password);
    }

    public FTPService.FTPServiceClient connectFTPS(String host, int port, String protocol, boolean isImplicit, long pbsz, String prot, String userName, String password) throws Exception {
        return new FTPSServiceClientImpl(host, port, protocol, isImplicit, pbsz, prot, userName, password);
    }

    private static void disconnect(FTPClient ftpClient) throws Exception {
        try {
            if (ftpClient != null && ftpClient.isConnected()) {
                ftpClient.disconnect();
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            ftpClient = null;
        }
    }

    private static void changeDirectory(FTPClient ftpClient, String directoryPath) throws Exception {
        if (ftpClient == null) {
            throw new JSException("Please connect to FTP server first before changing directory!");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Original Working directory = " + ftpClient.printWorkingDirectory()));
        }
        ftpClient.changeWorkingDirectory(directoryPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("NEW Working directory = " + ftpClient.printWorkingDirectory()));
        }
    }

    private static InputStream getFile(FTPClient ftpClient, String fileName) throws Exception {
        if (ftpClient == null) {
            throw new JSException("Please connect to FTP server first before changing directory!");
        }
        return ftpClient.retrieveFileStream(fileName);
    }

    private static void putFile(FTPClient ftpClient, String fileName, InputStream inputData) throws Exception {
        if (ftpClient == null) {
            throw new JSException("Please connect to FTP server first before changing directory!");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("START:  FUT FILE = " + fileName));
        }
        ftpClient.setFileType(2);
        boolean state = ftpClient.storeFile(ftpClient.printWorkingDirectory() + "/" + fileName, inputData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("END:  FUT FILE = " + fileName + " STATE = " + state));
        }
        if (!state) {
            throw new JSException("Fail to upload file " + fileName);
        }
    }

    private static boolean exists(FTPClient ftpClient, String fileName) throws Exception {
        if (ftpClient == null) {
            throw new JSException("Please connect to FTP server first before changing directory!");
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("FTP Working directory = " + ftpClient.printWorkingDirectory()));
            }
            FTPFile[] files = ftpClient.listFiles(ftpClient.printWorkingDirectory());
            if (log.isDebugEnabled()) {
                log.debug((Object)("FTP:  number of files - " + (files == null ? "NULL" : Integer.valueOf(files.length))));
            }
            if (files == null) {
                return false;
            }
            for (FTPFile ftpFile : files) {
                if (!ftpFile.getName().equalsIgnoreCase(fileName)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public class FTPServiceClientImpl
    implements FTPService.FTPServiceClient {
        private FTPClient ftpClient = new FTPClient();

        public FTPServiceClientImpl(String host, int port, String userName, String password) throws Exception {
            int reply;
            this.ftpClient.connect(host, port);
            if (!this.ftpClient.login(userName, password)) {
                this.ftpClient.logout();
                throw new JSException("FTP:  Fail to login:  may due to invalid username/ password.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("FTP:  connected to " + host + " LOGIN OK."));
            }
            if (!FTPReply.isPositiveCompletion((int)(reply = this.ftpClient.getReplyCode()))) {
                this.ftpClient.disconnect();
                throw new JSException("FTP:  unable to connect to " + host);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Connected to " + host + " REPLY OK."));
            }
            this.ftpClient.enterLocalPassiveMode();
        }

        public void disconnect() throws Exception {
            FTPUtil.disconnect(this.ftpClient);
        }

        public void changeDirectory(String directoryPath) throws Exception {
            FTPUtil.changeDirectory(this.ftpClient, directoryPath);
        }

        public InputStream getFile(String fileName) throws Exception {
            return FTPUtil.getFile(this.ftpClient, fileName);
        }

        public void putFile(String fileName, InputStream inputData) throws Exception {
            FTPUtil.putFile(this.ftpClient, fileName, inputData);
        }

        public boolean exists(String fileName) throws Exception {
            return FTPUtil.exists(this.ftpClient, fileName);
        }
    }

    public class FTPSServiceClientImpl
    implements FTPService.FTPServiceClient {
        private FTPSClient ftpClient = null;

        public FTPSServiceClientImpl(String host, int port, String protocol, boolean isImplicit, long pbsz, String prot, String userName, String password) throws Exception {
            int reply;
            if (protocol == null) {
                protocol = "TLS";
            }
            if (pbsz < 0L) {
                pbsz = 0L;
            }
            if (prot == null) {
                prot = "P";
            }
            this.ftpClient = new FTPSClient(protocol, isImplicit);
            this.ftpClient.connect(host, port);
            if (!this.ftpClient.login(userName, password)) {
                this.ftpClient.logout();
                throw new JSException("FTPS:  Invalid user name/ password.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("FTPS:  connected to " + host + " LOGIN OK."));
            }
            if (!FTPReply.isPositiveCompletion((int)(reply = this.ftpClient.getReplyCode()))) {
                this.ftpClient.disconnect();
                throw new JSException("FTPS:  unable to connect to " + host);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Connected to " + host + " REPLY OK."));
            }
            this.ftpClient.execPBSZ(pbsz);
            this.ftpClient.execPROT(prot);
            this.ftpClient.enterLocalPassiveMode();
        }

        public void disconnect() throws Exception {
            FTPUtil.disconnect((FTPClient)this.ftpClient);
        }

        public void changeDirectory(String directoryPath) throws Exception {
            FTPUtil.changeDirectory((FTPClient)this.ftpClient, directoryPath);
        }

        public InputStream getFile(String fileName) throws Exception {
            return FTPUtil.getFile((FTPClient)this.ftpClient, fileName);
        }

        public void putFile(String fileName, InputStream inputData) throws Exception {
            FTPUtil.putFile((FTPClient)this.ftpClient, fileName, inputData);
        }

        public boolean exists(String fileName) throws Exception {
            return FTPUtil.exists((FTPClient)this.ftpClient, fileName);
        }
    }
}

