/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.impl;

import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.ConnectionFactory;
import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.DataSource;
import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.JdbcDataSource;
import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.JndiDataSource;
import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.VirtualDataSourceException;
import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.VirtualDataSourceQueryService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.PooledObjectCache;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.PooledObjectEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractVirtualDataSourceQueryServiceImpl
implements VirtualDataSourceQueryService {
    private PooledObjectCache dataSourceCache = new PooledObjectCache();
    private int poolTimeoutInMinute;
    protected static final Log log = LogFactory.getLog(VirtualDataSourceQueryService.class);

    public int getPoolTimeoutInMinute() {
        return this.poolTimeoutInMinute;
    }

    public void setPoolTimeoutInMinute(int poolTimeoutInMinute) {
        this.poolTimeoutInMinute = poolTimeoutInMinute;
    }

    public ConnectionFactory getConnectionFactory(Collection<DataSource> dataSourceCollection) throws Exception {
        this.debug("********* getConnectionFactory [BEGIN] *********************");
        try {
            this.init();
            StringBuffer virtualDSKey = new StringBuffer("|");
            ArrayList<String> dataSourceNames = new ArrayList<String>();
            ArrayList<String> dataSourceIDs = new ArrayList<String>();
            ArrayList<DataSource> reportDataSources = new ArrayList<DataSource>();
            long now = System.currentTimeMillis();
            DataSource firstSubDataSource = null;
            for (DataSource subDataSource : dataSourceCollection) {
                if (firstSubDataSource == null) {
                    firstSubDataSource = subDataSource;
                }
                String dataSourceID = this.getDataSourceID(subDataSource);
                this.addOrMarkSubDataSource(dataSourceID, subDataSource, now);
                virtualDSKey.append(dataSourceID + this.getSubDataSourceInfo(subDataSource) + "|");
                dataSourceIDs.add(dataSourceID);
                dataSourceNames.add(subDataSource.getDataSourceName());
                reportDataSources.add(subDataSource);
            }
            if (firstSubDataSource != null) {
                virtualDSKey.append(this.getAdditionalInformation(firstSubDataSource));
            }
            this.debug("Virtual DS Key = " + virtualDSKey.toString());
            String virtualDSID = virtualDSKey.toString().hashCode() + "";
            this.markDataSourceUsed(virtualDSID, DataSourceType.MASTER_DATASOURCE, now);
            ConnectionFactory connectionFactory = this.createConnectionFactory(virtualDSID, dataSourceNames, dataSourceIDs, reportDataSources);
            this.releaseExpiredPools(now);
            this.debug("********* getConnectionFactory [END] *********************");
            return connectionFactory;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public abstract void init();

    public abstract ConnectionFactory createConnectionFactory(String var1, List<String> var2, List<String> var3, List<DataSource> var4) throws Exception;

    public abstract void undeployVirtualDataSource(String var1) throws Exception;

    public abstract boolean isSubDataSourceExisted(String var1);

    public abstract void addSubDataSource(String var1, DataSource var2) throws Exception;

    public abstract void removeSubDataSource(String var1) throws Exception;

    public abstract String getAdditionalInformation(DataSource var1) throws VirtualDataSourceException;

    protected String getDataSourceID(DataSource dataSource) {
        if (dataSource instanceof JdbcDataSource) {
            return this.getJdbcDataSourceID((JdbcDataSource)dataSource);
        }
        if (dataSource instanceof JndiDataSource) {
            return this.getJndiDataSourceID((JndiDataSource)dataSource);
        }
        return dataSource.hashCode() + "";
    }

    private String getJdbcDataSourceID(JdbcDataSource jdbcDataSource) {
        String key = jdbcDataSource.getConnectionUrl() + "|" + jdbcDataSource.getDriverClass() + "|" + jdbcDataSource.getUsername() + "|" + jdbcDataSource.getPassword();
        return key.hashCode() + "";
    }

    private String getJndiDataSourceID(JndiDataSource jndiDataSource) {
        String key = jndiDataSource.getJndiName();
        return key.hashCode() + "";
    }

    private synchronized void addOrMarkSubDataSource(String subDataSourceID, DataSource subDataSource, long currentTime) throws Exception {
        if (!this.isSubDataSourceExisted(subDataSourceID)) {
            this.addSubDataSource(subDataSourceID, subDataSource);
        }
        this.markDataSourceUsed(subDataSourceID, DataSourceType.SUB_DATASOURCE, currentTime);
    }

    protected Set<String> getSchemaSet(DataSource dataSource) {
        if (dataSource instanceof JdbcDataSource) {
            return ((JdbcDataSource)dataSource).getSchemas();
        }
        if (dataSource instanceof JndiDataSource) {
            return ((JndiDataSource)dataSource).getSchemas();
        }
        return null;
    }

    private String getSubDataSourceInfo(DataSource dataSource) {
        StringBuffer schemaString = new StringBuffer("[" + dataSource.getDataSourceName() + "]");
        Set<String> schemaList = this.getSchemaSet(dataSource);
        if (schemaList == null) {
            schemaString.append("[*]");
            return schemaString.toString();
        }
        schemaString.append("[");
        for (String schema : schemaList) {
            schemaString.append(schema + ";");
        }
        return schemaString.append("]").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markDataSourceUsed(String poolKey, DataSourceType dataSourceType, long now) {
        if (this.getPoolTimeoutInMinute() <= 0) {
            return;
        }
        PooledObjectCache pooledObjectCache = this.dataSourceCache;
        synchronized (pooledObjectCache) {
            PooledObjectEntry pooledObjectEntry = this.dataSourceCache.get(poolKey, now);
            if (pooledObjectEntry == null) {
                this.dataSourceCache.put(poolKey, new PooledVirtualDataSourceEntry(poolKey, dataSourceType), now);
                if (dataSourceType == DataSourceType.MASTER_DATASOURCE) {
                    this.debug("Acquire Virtual Data Source Pool Key: " + poolKey + ".");
                } else {
                    this.debug("Acquire Sub Data Source Pool Key: " + poolKey + ".");
                }
            } else if (dataSourceType == DataSourceType.MASTER_DATASOURCE) {
                this.debug("Update Virtual Data Source Pool Key: " + poolKey + ".");
            } else {
                this.debug("Update Sub Data Source Pool Key: " + poolKey + ".");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseExpiredPools(long now) {
        if (this.getPoolTimeoutInMinute() <= 0) {
            return;
        }
        List<PooledObjectEntry> expired = null;
        PooledObjectCache pooledObjectCache = this.dataSourceCache;
        synchronized (pooledObjectCache) {
            expired = this.dataSourceCache.removeExpired(now, this.getPoolTimeoutInMinute() * 60);
        }
        if (expired != null && !expired.isEmpty()) {
            for (PooledVirtualDataSourceEntry pooledVirtualDataSourceEntry : expired) {
                try {
                    pooledVirtualDataSourceEntry.release();
                }
                catch (Exception e) {
                    log.error((Object)"Error while releasing Virtual Pool Key.", (Throwable)e);
                }
            }
        }
    }

    protected boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }

    protected void debug(Object debugMessage) {
        if (log.isDebugEnabled()) {
            log.debug(debugMessage);
        }
    }

    protected void debug(Object debugMessage, Throwable throwable) {
        if (log.isDebugEnabled()) {
            log.debug(debugMessage, throwable);
        }
    }

    class PooledVirtualDataSourceEntry
    extends PooledObjectEntry {
        private DataSourceType dataSourceType;

        public PooledVirtualDataSourceEntry(Object key, DataSourceType dataSourceType) {
            super(key);
            this.dataSourceType = dataSourceType;
        }

        @Override
        public void release() throws Exception {
            switch (this.dataSourceType) {
                case MASTER_DATASOURCE: {
                    AbstractVirtualDataSourceQueryServiceImpl.this.undeployVirtualDataSource((String)this.getKey());
                    break;
                }
                case SUB_DATASOURCE: {
                    AbstractVirtualDataSourceQueryServiceImpl.this.removeSubDataSource((String)this.getKey());
                }
            }
        }
    }

    protected static enum DataSourceType {
        SUB_DATASOURCE,
        MASTER_DATASOURCE;

    }
}

