/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.EngineServiceImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import java.util.Map;
import javax.annotation.Resource;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.vote.AccessDecisionVoter;
import org.springframework.stereotype.Component;

@Component
public class ExecutionOwnerVoter
implements AccessDecisionVoter {
    public static final String ATTRIBUTE_EXECUTION_OWNER = "EXECUTION_OWNER";
    @Resource
    private Map<String, EngineServiceImpl.ReportExecutionStatus> engineExecutions;
    @Resource(name="concreteSecurityContextProvider")
    private SecurityContextProvider securityContextProvider;

    public boolean supports(ConfigAttribute attribute) {
        return ATTRIBUTE_EXECUTION_OWNER.equals(attribute.getAttribute());
    }

    public boolean supports(Class clazz) {
        return MethodInvocation.class.isAssignableFrom(clazz);
    }

    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        MethodInvocation invocation;
        String executionId;
        EngineServiceImpl.ReportExecutionStatus status;
        int result = 0;
        if (ATTRIBUTE_EXECUTION_OWNER.equals(((ConfigAttribute)config.getConfigAttributes().iterator().next()).getAttribute()) && (status = this.engineExecutions.get(executionId = (String)(invocation = (MethodInvocation)object).getArguments()[0])) != null) {
            User currentUser = this.securityContextProvider.getContextUser();
            result = status.getOwner().equals(currentUser) ? 1 : -1;
        }
        return result;
    }
}

