/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JdbcDataSourceService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JdbcReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.util.JndiFallbackResolver;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import java.util.Map;
import java.util.TimeZone;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JndiJdbcReportDataSourceServiceFactory
extends JdbcReportDataSourceServiceFactory {
    private static final Log log = LogFactory.getLog(JndiJdbcReportDataSourceServiceFactory.class);
    private Context ctx = null;
    private boolean disableJndi;
    private JndiFallbackResolver jndiFallbackResolver;

    public JndiJdbcReportDataSourceServiceFactory() {
        try {
            this.ctx = new InitialContext();
        }
        catch (NamingException e) {
            log.error((Object)e);
            throw new JSException((Throwable)e);
        }
    }

    @Override
    public ReportDataSourceService createService(ReportDataSource dataSource) {
        JndiJdbcReportDataSource jndiDataSource = (JndiJdbcReportDataSource)dataSource;
        TimeZone timeZone = this.getTimeZoneByDataSourceTimeZone(jndiDataSource.getTimezone());
        String jndiName = jndiDataSource.getJndiName();
        if (this.disableJndi || this.ctx == null) {
            return this.createServiceFromFallbackProperties(jndiName, timeZone);
        }
        try {
            DataSource ds = (DataSource)this.ctx.lookup("java:comp/env/" + jndiName);
            return new JdbcDataSourceService(ds, timeZone);
        }
        catch (NoInitialContextException e) {
            this.ctx = null;
            return this.createService(dataSource);
        }
        catch (NamingException e) {
            try {
                DataSource ds = (DataSource)this.ctx.lookup(jndiName);
                return new JdbcDataSourceService(ds, timeZone);
            }
            catch (NamingException ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e, (Throwable)e);
                }
                throw new JSExceptionWrapper((Exception)e);
            }
        }
    }

    private ReportDataSourceService createServiceFromFallbackProperties(String jndiName, TimeZone timeZone) {
        Map jdbcMap = this.jndiFallbackResolver.getJdbcPropertiesMap(jndiName);
        DataSource datasource = this.getPoolDataSource((String)jdbcMap.get("driverClassName"), (String)jdbcMap.get("url"), (String)jdbcMap.get("username"), (String)jdbcMap.get("password"));
        return new JdbcDataSourceService(datasource, timeZone);
    }

    public void setDisableJndi(boolean disableJndi) {
        this.disableJndi = disableJndi;
    }

    public boolean isDisableJndi() {
        return this.disableJndi;
    }

    public void setJndiFallbackResolver(JndiFallbackResolver jndiFallbackResolver) {
        this.jndiFallbackResolver = jndiFallbackResolver;
    }
}

