/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.common.properties.PropertyChangerAdapter;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.AwsProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AwsPropertyChanger
extends PropertyChangerAdapter {
    public static final String PROPERTY_PREFIX = "aws.";
    protected static final Log log = LogFactory.getLog(AwsPropertyChanger.class);
    private AwsProperties awsProperties;

    public void setProperty(String key, String val) {
        assert (key.startsWith(PROPERTY_PREFIX));
        log.debug((Object)("setting AWS property: " + key + " - " + val));
        if ("aws.db.security.group.changes.enabled".equals(key)) {
            this.awsProperties.setSecurityGroupChangesEnabled(Boolean.valueOf(val));
        } else if ("aws.db.security.group.name".equals(key)) {
            this.awsProperties.setSecurityGroupName(val);
        } else if ("aws.db.security.group.description".equals(key)) {
            this.awsProperties.setSecurityGroupDescription(val);
        } else if ("aws.db.security.group.ingressPublicIp".equals(key)) {
            this.awsProperties.setSecurityGroupIngressPublicIp(val);
        } else if ("aws.db.security.group.suppressEc2CredentialsWarnings".equals(key)) {
            this.awsProperties.setSuppressEc2CredentialsWarnings(Boolean.valueOf(val));
        } else {
            throw new RuntimeException("Unknown AWS config property: " + key);
        }
    }

    public String getProperty(String key) {
        assert (key.startsWith(PROPERTY_PREFIX));
        log.debug((Object)("getting AWS property: " + key));
        if ("aws.db.security.group.changes.enabled".equals(key)) {
            return Boolean.toString(this.awsProperties.isSecurityGroupChangesEnabled());
        }
        if ("aws.db.security.group.name".equals(key)) {
            return this.awsProperties.getSecurityGroupName();
        }
        if ("aws.db.security.group.description".equals(key)) {
            return this.awsProperties.getSecurityGroupDescription();
        }
        if ("aws.db.security.group.ingressPublicIp".equals(key)) {
            return this.awsProperties.getSecurityGroupIngressPublicIp();
        }
        if ("aws.db.security.group.suppressEc2CredentialsWarnings".equals(key)) {
            return Boolean.toString(this.awsProperties.isSuppressEc2CredentialsWarnings());
        }
        throw new RuntimeException("Unknown AWS config property: " + key);
    }

    public void setAwsProperties(AwsProperties awsProperties) {
        this.awsProperties = awsProperties;
    }
}

