/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JarConnection;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JarFileEntry;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.commons.collections.ReferenceMap;

public class JarURLStreamHandler
extends URLStreamHandler {
    private static final String PROTOCOL = "jsjar";
    private static final String URL_PREFIX = "jsjar:";
    private static final int URL_PREFIX_LENGHT = "jsjar:".length();
    private static final String SEPARATOR = "!";
    private static final int SEPARATOR_LENGHT = "!".length();
    private final ReferenceMap urlStreams = new ReferenceMap(2, 0);

    @Override
    protected void parseURL(URL u, String spec, int start, int limit) {
        String quotedSpec = "\"" + spec + "\"";
        if (!spec.startsWith(URL_PREFIX)) {
            throw new JSException("jsexception.jar.malformed.url", new Object[]{quotedSpec});
        }
        int sep = spec.indexOf(SEPARATOR);
        if (sep < 0) {
            throw new JSException("jsexception.jar.malformed.url", new Object[]{quotedSpec});
        }
        String jar = spec.substring(URL_PREFIX_LENGHT, sep);
        String res = spec.substring(sep + SEPARATOR_LENGHT, spec.length());
        this.setURL(u, PROTOCOL, null, -1, null, null, jar, null, res);
    }

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        JarFileEntry entry = this.getURLEntry(u);
        if (entry == null) {
            throw new JSException("jsexception.jar.entry.not.found", new Object[]{u});
        }
        return new JarConnection(u, entry);
    }

    public URL createURL(JarFileEntry jarEntry) {
        try {
            String spec = URL_PREFIX + jarEntry.getJarFile().getName() + SEPARATOR + jarEntry.getEntry().getName();
            URL url = new URL(null, spec, this);
            this.putURL(url, jarEntry);
            return url;
        }
        catch (MalformedURLException e) {
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    public synchronized void putURL(URL u, JarFileEntry jarEntry) {
        this.urlStreams.put((Object)u, (Object)jarEntry);
    }

    protected synchronized JarFileEntry getURLEntry(URL u) {
        return (JarFileEntry)this.urlStreams.get((Object)u);
    }

    @Override
    protected boolean equals(URL u1, URL u2) {
        return u1 == u2;
    }

    @Override
    protected int hashCode(URL u) {
        return System.identityHashCode(u);
    }

    @Override
    protected String toExternalForm(URL u) {
        return URL_PREFIX + u.getPath() + SEPARATOR + u.getRef();
    }
}

