/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryUtil;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.util.RepositoryUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.sf.jasperreports.repo.PersistenceService;
import net.sf.jasperreports.repo.Resource;
import net.sf.jasperreports.repo.StreamRepositoryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepoRepositoryService
implements net.sf.jasperreports.repo.RepositoryService,
StreamRepositoryService {
    private static final Log log = LogFactory.getLog(RepoRepositoryService.class);
    private Map<Class<?>, PersistenceService> persistenceServices;

    @Deprecated
    public void setContext(net.sf.jasperreports.repo.RepositoryContext context) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void revertContext() {
        throw new UnsupportedOperationException();
    }

    public Resource getResource(String uri) {
        throw new UnsupportedOperationException();
    }

    public void saveResource(String uri, Resource resource) {
        throw new UnsupportedOperationException();
    }

    public InputStream getInputStream(String uri) {
        InputStream data;
        RepositoryContext repositoryContext = RepositoryUtil.getThreadRepositoryContext();
        if (repositoryContext == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No repository context for resource " + uri));
            }
            return null;
        }
        if (uri.startsWith("repo:") || uri.startsWith("file:") || uri.startsWith("http:") || uri.startsWith("https:")) {
            return null;
        }
        String path = RepositoryUtils.resolveRelativePath((String)repositoryContext.getContextURI(), (String)uri);
        ExecutionContext executionContext = repositoryContext.getExecutionContext();
        RepositoryService repository = repositoryContext.getRepository();
        if (log.isDebugEnabled()) {
            log.debug((Object)("loading repository resource " + path + ", context path " + repositoryContext.getContextURI() + ", uri " + uri));
        }
        FileResource resource = (FileResource)repository.getResource(executionContext, path, FileResource.class);
        while (resource != null && resource.isReference()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("loading repository resource " + resource.getReferenceURI()));
            }
            resource = (FileResource)repository.getResource(executionContext, resource.getReferenceURI(), FileResource.class);
        }
        if (resource == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource \"" + path + "\" not found in the repository"));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("loaded resource of type " + resource.getFileType()));
        }
        if (resource.getFileType().equals("jrxml")) {
            data = repositoryContext.getCompiledReportProvider().getCompiledReport(executionContext, path);
        } else {
            FileResourceData resourceData = repository.getResourceData(executionContext, path);
            data = resourceData.getDataStream();
        }
        return data;
    }

    public <K extends Resource> K getResource(String uri, Class<K> resourceType) {
        PersistenceService persistenceService = this.persistenceServices.get(resourceType);
        if (persistenceService == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unknown resource type " + resourceType.getClass().getName() + " requested"));
            }
            return null;
        }
        Resource resource = persistenceService.load(uri, (net.sf.jasperreports.repo.RepositoryService)this);
        return (K)resource;
    }

    public OutputStream getOutputStream(String uri) {
        throw new UnsupportedOperationException();
    }

    public Map<Class<?>, PersistenceService> getPersistenceServices() {
        return this.persistenceServices;
    }

    public void setPersistenceServices(Map<Class<?>, PersistenceService> persistenceServices) {
        this.persistenceServices = persistenceServices;
    }
}

