/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.hibernate;

import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobAlert;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobAlertModel;
import java.util.ArrayList;
import java.util.List;

public class PersistentReportJobAlert {
    private long id;
    private int version = -1;
    private byte recipient = ReportJobAlert.Recipient.OWNER_AND_ADMIN.getCode();
    private List<String> toAddresses = new ArrayList<String>();
    private byte jobState = ReportJobAlert.JobState.FAIL_ONLY.getCode();
    private String messageText = null;
    private String messageTextWhenJobFails = null;
    private String subject = null;
    private boolean includingStackTrace = true;
    private boolean includingReportJobInfo = true;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public byte getRecipient() {
        return this.recipient;
    }

    public void setRecipient(byte recipient) {
        this.recipient = recipient;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public List<String> getToAddresses() {
        if (this.toAddresses == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> addresses = new ArrayList<String>();
        for (String address : this.toAddresses) {
            addresses.add(address);
        }
        return addresses;
    }

    public void setToAddresses(List<String> toAddresses) {
        if (toAddresses == null) {
            toAddresses = new ArrayList<String>();
        }
        this.toAddresses = toAddresses;
    }

    public byte getJobState() {
        return this.jobState;
    }

    public void setJobState(byte jobState) {
        this.jobState = jobState;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    public String getMessageTextWhenJobFails() {
        return this.messageTextWhenJobFails;
    }

    public void setMessageTextWhenJobFails(String messageTextWhenJobFails) {
        this.messageTextWhenJobFails = messageTextWhenJobFails;
    }

    public boolean isIncludingStackTrace() {
        return this.includingStackTrace;
    }

    public void setIncludingStackTrace(boolean includingStackTrace) {
        this.includingStackTrace = includingStackTrace;
    }

    public boolean isIncludingReportJobInfo() {
        return this.includingReportJobInfo;
    }

    public void setIncludingReportJobInfo(boolean includingReportJobInfo) {
        this.includingReportJobInfo = includingReportJobInfo;
    }

    public void copyFrom(ReportJobAlert alert) {
        this.setRecipient(alert.getRecipient().getCode());
        this.setToAddresses(alert.getToAddresses());
        this.setJobState(alert.getJobState().getCode());
        this.setMessageText(alert.getMessageText());
        this.setMessageTextWhenJobFails(alert.getMessageTextWhenJobFails());
        this.setSubject(alert.getSubject());
        this.setIncludingStackTrace(alert.isIncludingStackTrace());
        this.setIncludingReportJobInfo(alert.isIncludingReportJobInfo());
    }

    public void copyFrom(ReportJobAlertModel alert) {
        if (alert.isRecipientModified()) {
            this.setRecipient(alert.getRecipient().getCode());
        }
        if (alert.isToAddressesModified()) {
            this.setToAddresses(alert.getToAddresses());
        }
        if (alert.isJobStateModified()) {
            this.setJobState(alert.getJobState().getCode());
        }
        if (alert.isMessageTextModified()) {
            this.setMessageText(alert.getMessageText());
        }
        if (alert.isMessageTextWhenJobFailsModified()) {
            this.setMessageText(alert.getMessageTextWhenJobFails());
        }
        if (alert.isIncludingStackTraceModified()) {
            this.setIncludingStackTrace(alert.isIncludingStackTrace());
        }
        if (alert.isIncludingReportJobInfoModified()) {
            this.setIncludingReportJobInfo(alert.isIncludingReportJobInfo());
        }
        if (alert.isSubjectModified()) {
            this.setSubject(alert.getSubject());
        }
    }

    public ReportJobAlert toClient() {
        ReportJobAlert alert = new ReportJobAlert();
        alert.setRecipient(ReportJobAlert.Recipient.fromCode((byte)this.getRecipient()));
        alert.setToAddresses(this.getToAddresses());
        alert.setJobState(ReportJobAlert.JobState.fromCode((byte)this.getJobState()));
        alert.setMessageText(this.getMessageText());
        alert.setMessageTextWhenJobFails(this.getMessageTextWhenJobFails());
        alert.setIncludingStackTrace(this.isIncludingStackTrace());
        alert.setIncludingReportJobInfo(this.isIncludingReportJobInfo());
        alert.setSubject(this.getSubject());
        return alert;
    }

    public boolean isNew() {
        return this.getVersion() == -1;
    }
}

