/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.LogEvent;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.common.util.CharacterEncodingProvider;
import com.jaspersoft.jasperserver.api.common.util.LocaleHelper;
import com.jaspersoft.jasperserver.api.engine.common.domain.ReportResult;
import com.jaspersoft.jasperserver.api.engine.common.domain.Request;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.common.service.LoggingService;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.engine.common.service.VirtualizerFactory;
import com.jaspersoft.jasperserver.api.engine.common.service.impl.ContentResourceURIResolver;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequest;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataCacheProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataSnapshotService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.EngineServiceImpl;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobAlert;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobIdHolder;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ExceptionInfo;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.HtmlReportOutput;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.Output;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportExecutionJobAlert;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportExecutionJobFileSaving;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportExecutionJobInit;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportExecutionJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportOutput;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsPersistenceService;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.context.impl.DummyAuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.logging.context.LoggingContextProvider;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainerFactory;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.DataContainerStreamUtil;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.util.LockManager;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataCacheSnapshot;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.WeakHashMap;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.SimpleReportContext;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.springframework.context.ApplicationContext;
import org.springframework.mail.javamail.JavaMailSender;

public class ReportExecutionJob
implements Job {
    private static final Log log = LogFactory.getLog(ReportExecutionJob.class);
    public static final String REPORT_PARAMETER_SCHEDULED_TIME = "_ScheduledTime";
    public static final String REPOSITORY_FILENAME_SEQUENCE_SEPARATOR = "-";
    public static final String REPOSITORY_FILENAME_TIMESTAMP_SEQUENCE_PATTERN = "yyyyMMddHHmm";
    public static final String SCHEDULER_CONTEXT_KEY_APPLICATION_CONTEXT = "applicationContext";
    public static final String SCHEDULER_CONTEXT_KEY_JOB_PERSISTENCE_SERVICE = "jobPersistenceService";
    public static final String SCHEDULER_CONTEXT_KEY_JOB_REPORT_SCHEDULING_SERVICE = "reportSchedulingService";
    public static final String SCHEDULER_CONTEXT_KEY_ENGINE_SERVICE = "engineService";
    public static final String SCHEDULER_CONTEXT_KEY_VIRTUALIZER_FACTORY = "virtualizerFactory";
    public static final String SCHEDULER_CONTEXT_KEY_REPOSITORY = "repositoryService";
    public static final String SCHEDULER_CONTEXT_KEY_MAIL_SENDER = "mailSender";
    public static final String SCHEDULER_CONTEXT_KEY_MAIL_FROM_ADDRESS = "mailFromAddress";
    public static final String SCHEDULER_CONTEXT_KEY_LOGGING_SERVICE = "loggingService";
    public static final String SCHEDULER_CONTEXT_KEY_SECURITY_CONTEXT_PROVIDER = "securityContextProvider";
    public static final String SCHEDULER_CONTEXT_KEY_HYPERLINK_PRODUCER_FACTORY = "hyperlinkProducerFactory";
    public static final String SCHEDULER_CONTEXT_KEY_ENCODING_PROVIDER = "encodingProvider";
    public static final String SCHEDULER_CONTEXT_KEY_EXPORT_PARAMETRES_MAP = "exportParametersMap";
    public static final String SCHEDULER_CONTEXT_KEY_DATA_CONTAINER_FACTORY = "dataContainerFactory";
    public static final String SCHEDULER_CONTEXT_KEY_CONTENT_RESOURCE_URI_RESOLVER = "contentResourceURIResolver";
    public static final String SCHEDULER_CONTEXT_KEY_LOCK_MANAGER = "lockManager";
    public static final String SCHEDULER_CONTEXT_KEY_OUTPUT_FORMAT_MAP = "outputFormatMap";
    public static final String SCHEDULER_CONTEXT_KEY_OUTPUT_KEY_MAPPING = "outputKeyMapping";
    public static final String SCHEDULER_CONTEXT_KEY_ADMINISTRATOR_ROLE = "administratorRole";
    public static final String SCHEDULER_CONTEXT_KEY_REPORT_EXECUTION_JOB_INIT = "reportExecutionJobInit";
    public static final String SCHEDULER_CONTEXT_KEY_REPORT_EXECUTION_JOB_ALERT = "reportExecutionJobAlert";
    public static final String SCHEDULER_CONTEXT_KEY_REPORT_EXECUTION_JOB_MAIL_NOTIFICATION = "reportExecutionJobMailNotification";
    public static final String SCHEDULER_CONTEXT_KEY_REPORT_EXECUTION_JOB_FILE_SAVING = "reportExecutionJobFileSaving";
    public static final String SCHEDULER_CONTEXT_KEY_DATA_SNAPSHOT_SERVICE_BEAN = "dataSnapshotServiceName";
    public static final String SCHEDULER_CONTEXT_KEY_DATA_CACHE_PROVIDER_BEAN = "dataCacheProviderName";
    public static final String SCHEDULER_CONTEXT_KEY_AUTO_DELETE_BROKEN_URI_REPORT_JOB = "autoDeleteBrokenUriReportJob";
    public static final String SCHEDULER_CONTEXT_KEY_JASPERREPORTS_CONTEXT_BEAN = "jasperReportsContextName";
    public static final String JOB_DATA_KEY_DETAILS_ID = "jobDetailsID";
    public static final String JOB_DATA_KEY_USERNAME = "jobUser";
    public static final String LOGGING_COMPONENT = "reportScheduler";
    protected List<ExceptionInfo> exceptions = new ArrayList<ExceptionInfo>();
    protected ApplicationContext applicationContext;
    protected String username;
    protected ReportJob jobDetails;
    protected ReportUnit reportUnit;
    protected JobExecutionContext jobContext;
    protected SchedulerContext schedulerContext;
    protected ExecutionContext executionContext;
    protected static AuditContext auditContext = new DummyAuditContext();
    protected static LoggingContextProvider loggingContextProvider;
    protected boolean cancelRequested = false;
    private ReportContext reportContext;
    private boolean hasDataSnapshotOutput;
    private boolean recordDataSnapshot;
    private boolean recordedDataSnapshot;
    private String dataSnapshotOutputName;
    private final WeakHashMap<DataContainer, Boolean> dataContainers = new WeakHashMap();

    public static void setAuditContext(AuditContext auditContext) {
        ReportExecutionJob.auditContext = auditContext;
    }

    public static void setLoggingContextProvider(LoggingContextProvider loggingContextProvider) {
        ReportExecutionJob.loggingContextProvider = loggingContextProvider;
    }

    protected void createAuditEvent() {
        auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                auditContext.createAuditEvent("runReport");
            }
        });
    }

    protected void addReportJobLabelToAuditEvent(final long jobID, final String jobLabel) {
        auditContext.doInAuditContext("runReport", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                auditContext.addPropertyToAuditEvent("jobID", (Object)jobID, auditEvent);
                auditContext.addPropertyToAuditEvent("jobLabel", (Object)jobLabel, auditEvent);
            }
        });
    }

    protected void addExceptionToAuditEvent(final Throwable ex) {
        auditContext.doInAuditContext("runReport", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                auditContext.addPropertyToAuditEvent("exception", (Object)ex, auditEvent);
            }
        });
    }

    protected void closeAuditEvent() {
        auditContext.doInAuditContext("runReport", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                auditContext.closeAuditEvent(auditEvent);
            }
        });
        if (loggingContextProvider != null) {
            loggingContextProvider.flushContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            this.jobContext = context;
            this.schedulerContext = this.jobContext.getScheduler().getContext();
            this.applicationContext = (ApplicationContext)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_APPLICATION_CONTEXT);
            this.username = this.getUsername();
            SecurityContextProvider securityContextProvider = this.getSecurityContextProvider();
            securityContextProvider.setAuthenticatedUser(this.username);
            this.createAuditEvent();
            try {
                this.executeAndSendReport();
            }
            finally {
                securityContextProvider.revertAuthenticatedUser();
            }
        }
        catch (JobExecutionException e) {
            this.addExceptionToAuditEvent(e);
            throw e;
        }
        catch (SchedulerException e) {
            this.addExceptionToAuditEvent(e);
            throw new JobExecutionException((Throwable)e);
        }
        finally {
            this.closeAuditEvent();
            this.clear();
        }
    }

    protected void initJobExecution() {
        this.updateExecutionContextDetails();
    }

    protected void clear() {
        this.exceptions.clear();
        this.jobContext = null;
        this.schedulerContext = null;
        this.jobDetails = null;
        this.reportUnit = null;
        this.executionContext = null;
        this.username = null;
        this.reportContext = null;
        this.hasDataSnapshotOutput = false;
        this.recordDataSnapshot = false;
        this.recordedDataSnapshot = false;
        this.dataSnapshotOutputName = null;
        for (DataContainer dataContainer : this.dataContainers.keySet()) {
            dataContainer.dispose();
        }
        this.dataContainers.clear();
    }

    protected String getUsername() {
        JobDataMap jobDataMap = this.jobContext.getTrigger().getJobDataMap();
        return jobDataMap.getString(JOB_DATA_KEY_USERNAME);
    }

    protected ExecutionContext getExecutionContext() {
        return new ExecutionContextImpl();
    }

    protected void updateExecutionContextDetails() {
        ExecutionContextImpl context = (ExecutionContextImpl)this.executionContext;
        context.setLocale(this.getLocale());
        context.setTimeZone(TimeZone.getDefault());
    }

    protected Locale getJobLocale() {
        String localeCode = this.jobDetails.getOutputLocale();
        Locale locale = localeCode != null && localeCode.length() > 0 ? LocaleHelper.getInstance().getLocale(localeCode) : null;
        return locale;
    }

    protected Locale getMessageLocale() {
        return this.getLocale();
    }

    protected Locale getLocale() {
        Locale locale = null;
        if (this.jobDetails != null) {
            locale = this.getJobLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    protected String getMessage(String key, Object[] arguments) {
        return this.applicationContext.getMessage(key, arguments, this.getMessageLocale());
    }

    protected void handleException(String message, Throwable exc) {
        log.error((Object)message, exc);
        this.exceptions.add(new ExceptionInfo(message, exc));
    }

    protected boolean hasExceptions() {
        return !this.exceptions.isEmpty();
    }

    protected void checkExceptions() throws JobExecutionException {
        if (this.hasExceptions()) {
            ExceptionInfo firstException = this.exceptions.get(0);
            try {
                this.logExceptions();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.throwJobExecutionException(firstException);
            }
            this.throwJobExecutionException(firstException);
        }
    }

    protected void throwJobExecutionException(ExceptionInfo exceptionInfo) throws JobExecutionException {
        Throwable exception = exceptionInfo.getException();
        JobExecutionException jobException = exception instanceof Exception ? new JobExecutionException(exceptionInfo.getMessage(), (Throwable)((Exception)exception), false) : new JobExecutionException(exceptionInfo.getMessage());
        throw jobException;
    }

    protected void logExceptions() {
        LoggingService loggingService = this.getLoggingService();
        LogEvent event = loggingService.instantiateLogEvent();
        event.setComponent(LOGGING_COMPONENT);
        event.setType((byte)1);
        event.setMessageCode("log.error.report.job.failed");
        if (this.jobDetails != null) {
            event.setResourceURI(this.jobDetails.getSource().getReportUnitURI());
        }
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        if (this.jobDetails != null) {
            printWriter.println("Job: " + this.jobDetails.getLabel() + " (ID: " + this.jobDetails.getId() + ")");
            printWriter.println("Report unit: " + this.jobDetails.getSource().getReportUnitURI());
        }
        printWriter.println("Quartz Job: " + this.jobContext.getJobDetail().getKey());
        printWriter.println("Quartz Trigger: " + this.jobContext.getTrigger().getKey());
        printWriter.println("Exceptions:");
        ListIterator<ExceptionInfo> it = this.exceptions.listIterator();
        while (it.hasNext()) {
            ExceptionInfo exceptionInfo = it.next();
            printWriter.println();
            printWriter.println(exceptionInfo.getMessage());
            Throwable exception = exceptionInfo.getException();
            if (exception == null) continue;
            exception.printStackTrace(printWriter);
        }
        printWriter.flush();
        event.setText(writer.toString());
        event.setState((byte)1);
        loggingService.log(event);
    }

    protected SecurityContextProvider getSecurityContextProvider() {
        return (SecurityContextProvider)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_SECURITY_CONTEXT_PROVIDER);
    }

    protected LoggingService getLoggingService() {
        return (LoggingService)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_LOGGING_SERVICE);
    }

    protected ReportJob getJobDetails() {
        ReportJobsPersistenceService persistenceService = this.getPersistenceService();
        JobDataMap jobDataMap = this.jobContext.getTrigger().getJobDataMap();
        long jobId = jobDataMap.getLong(JOB_DATA_KEY_DETAILS_ID);
        ReportJob job = persistenceService.loadJob(this.executionContext, new ReportJobIdHolder(jobId));
        return job;
    }

    protected ReportJobsPersistenceService getPersistenceService() {
        return (ReportJobsPersistenceService)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_JOB_PERSISTENCE_SERVICE);
    }

    protected ReportSchedulingService getReportSchedulingService() {
        return (ReportSchedulingService)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_JOB_REPORT_SCHEDULING_SERVICE);
    }

    protected EngineService getEngineService() {
        EngineService engineService = (EngineService)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_ENGINE_SERVICE);
        return engineService;
    }

    protected VirtualizerFactory getVirtualizerFactory() {
        return (VirtualizerFactory)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_VIRTUALIZER_FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeAndSendReport() throws JobExecutionException {
        try {
            this.executionContext = this.getExecutionContext();
            this.jobDetails = this.getJobDetails();
            this.initJobExecution();
            this.addReportJobLabelToAuditEvent(this.jobDetails.getId(), this.jobDetails.getLabel());
            ReportUnitResult paginatedResult = null;
            ReportUnitResult nonPaginatedResult = null;
            boolean isMailNotificationSent = false;
            try {
                this.reportUnit = (ReportUnit)this.getRepository().getResource(this.executionContext, this.getReportUnitURI(), ReportUnit.class);
                if (this.reportUnit == null) {
                    if (!this.isAutoDeleteBrokenUriReportJob()) throw new JSException("report.scheduling.error.broken.report.uri");
                    this.getReportSchedulingService().removeScheduledJob(this.executionContext, this.jobDetails.getId());
                    log.info((Object)("The following report doesn't exist: " + this.getReportUnitURI() + ".  Deleting ReportJob ID = " + this.jobDetails.getId()));
                    return;
                }
                if (this.getReportExecutionJobInit() != null) {
                    this.jobDetails = this.getReportExecutionJobInit().initJob(this, this.jobDetails);
                }
                boolean needPaginatedReport = false;
                boolean needNonPaginatedReport = false;
                List<Output> outputs = this.createOutputs();
                for (Output output : outputs) {
                    boolean ignorePagination = output.isIgnorePagination();
                    needPaginatedReport = needPaginatedReport || !ignorePagination;
                    needNonPaginatedReport = needNonPaginatedReport || ignorePagination;
                }
                this.isCancelRequested();
                if (this.hasDataSnapshotOutput && !needPaginatedReport && !needNonPaginatedReport) {
                    needPaginatedReport = true;
                }
                boolean bl = this.recordDataSnapshot = this.getDataSnapshotService().isSnapshotPersistenceEnabled() || needPaginatedReport && needNonPaginatedReport;
                if (needPaginatedReport) {
                    paginatedResult = this.executeReport(null);
                }
                if (needNonPaginatedReport) {
                    nonPaginatedResult = this.executeReport(Boolean.TRUE);
                }
                if (paginatedResult != null || nonPaginatedResult != null) {
                    this.isCancelRequested();
                    ReportJobMailNotification mailNotification = this.jobDetails.getMailNotification();
                    boolean skipEmpty = false;
                    if (mailNotification != null) {
                        skipEmpty = mailNotification.isSkipEmptyReports() && (this.isEmpty(paginatedResult) || this.isEmpty(nonPaginatedResult));
                    }
                    ArrayList<ReportOutput> reportOutputs = new ArrayList<ReportOutput>();
                    if (!skipEmpty) {
                        String baseFileName = this.getBaseFileName();
                        boolean useFolderHierarchy = true;
                        if (mailNotification != null && (mailNotification.getResultSendTypeCode() == 3 || mailNotification.getResultSendTypeCode() == 4)) {
                            useFolderHierarchy = false;
                        }
                        for (Output output : outputs) {
                            ReportOutput reportOutput = null;
                            if (nonPaginatedResult != null && output.isIgnorePagination() || paginatedResult != null && !output.isIgnorePagination()) {
                                if (mailNotification != null && mailNotification.getResultSendType() == 4 && output instanceof HtmlReportOutput) {
                                    ((HtmlReportOutput)output).setForceToUseHTMLExporter(true);
                                }
                                this.isCancelRequested();
                                try {
                                    reportOutput = output.getOutput(this.getEngineService(), this.executionContext, this.getReportUnitURI(), this.createDataContainer(output), this.getHyperlinkProducerFactory(), useFolderHierarchy ? this.getRepository() : null, output.isIgnorePagination() ? nonPaginatedResult.getJasperPrint() : paginatedResult.getJasperPrint(), baseFileName, this.getLocale(), this.getCharacterEncoding());
                                }
                                catch (Exception e) {
                                    String fileExtension = null;
                                    Map outputFormatMap = this.getOutputFormatMap();
                                    for (Object currentExtension : outputFormatMap.keySet()) {
                                        if (outputFormatMap.get(currentExtension) != output) continue;
                                        fileExtension = currentExtension.toString();
                                        break;
                                    }
                                    this.handleException(this.getMessage("report.scheduling.error.exporting.report", new Object[]{fileExtension}), e);
                                    continue;
                                }
                                this.isCancelRequested();
                                if (reportOutput != null) {
                                    reportOutputs.add(reportOutput);
                                }
                            }
                            this.isCancelRequested();
                            if (!useFolderHierarchy && this.jobDetails.getContentRepositoryDestination() != null && this.jobDetails.getContentRepositoryDestination().isSaveToRepository() && !reportOutput.getChildren().isEmpty()) {
                                ReportOutput reportOutputForRepository = output.getOutput(this.getEngineService(), this.executionContext, this.getReportUnitURI(), this.createDataContainer(output), this.getHyperlinkProducerFactory(), this.getRepository(), output.isIgnorePagination() ? nonPaginatedResult.getJasperPrint() : paginatedResult.getJasperPrint(), baseFileName, this.getLocale(), this.getCharacterEncoding());
                                this.isCancelRequested();
                                if (reportOutputForRepository == null) continue;
                                this.getReportExecutionJobFileSaving().save(this, reportOutputForRepository, true, this.jobDetails);
                                continue;
                            }
                            this.getReportExecutionJobFileSaving().save(this, reportOutput, useFolderHierarchy, this.jobDetails);
                        }
                    }
                    if (mailNotification != null && (!skipEmpty || this.hasExceptions())) {
                        ArrayList<ReportOutput> attachments = skipEmpty ? null : reportOutputs;
                        this.isCancelRequested();
                        try {
                            isMailNotificationSent = true;
                            this.sendMailNotification(attachments);
                        }
                        catch (Exception e) {
                            this.handleException(this.getMessage("report.scheduling.error.sending.email.notification", null), e);
                        }
                    }
                }
                this.disposeVirtualizer(paginatedResult);
            }
            catch (CancelRequestException cancelRequestException) {
                this.handleException(this.getMessage("report.scheduling.cancelling.by.request", null), (Throwable)((Object)cancelRequestException));
                return;
            }
            catch (Exception otherException) {
                this.handleException(this.getMessage("error.generating.report", null), otherException);
                return;
            }
            this.disposeVirtualizer(nonPaginatedResult);
            if (!isMailNotificationSent) {
                try {
                    if (this.jobDetails.getMailNotification() != null && this.hasExceptions()) {
                        this.sendMailNotification(new ArrayList());
                    }
                }
                catch (Exception e) {
                    this.handleException(this.getMessage("report.scheduling.error.sending.email.notification", null), e);
                }
            }
            try {
                this.sendAlertMail();
                return;
            }
            catch (Exception e) {
                this.handleException(this.getMessage("fail to send out alert mail notification", null), e);
                return;
            }
            finally {
                this.disposeVirtualizer(paginatedResult);
                this.disposeVirtualizer(nonPaginatedResult);
                if (!isMailNotificationSent) {
                    try {
                        if (this.jobDetails.getMailNotification() != null && this.hasExceptions()) {
                            this.sendMailNotification(new ArrayList());
                        }
                    }
                    catch (Exception e) {
                        this.handleException(this.getMessage("report.scheduling.error.sending.email.notification", null), e);
                    }
                }
                try {
                    this.sendAlertMail();
                }
                catch (Exception e) {
                    this.handleException(this.getMessage("fail to send out alert mail notification", null), e);
                }
            }
        }
        catch (Throwable e) {
            this.handleException(this.getMessage("report.scheduling.error.system", null), e);
            return;
        }
        finally {
            this.checkExceptions();
        }
    }

    protected void sendAlertMail() throws JobExecutionException {
        ReportJobAlert alert = this.jobDetails.getAlert();
        if (alert == null) {
            return;
        }
        JavaMailSender mailSender = this.getMailSender();
        String fromAddress = this.getFromAddress();
        String[] toAddresses = this.getAlertMailRecipients(alert);
        if (toAddresses == null || toAddresses.length == 0) {
            return;
        }
        String characterEncoding = this.getCharacterEncoding();
        this.getReportExecutionJobAlert().sendAlertMail(this, this.jobDetails, this.exceptions, mailSender, fromAddress, toAddresses, characterEncoding);
    }

    protected void disposeVirtualizer(ReportUnitResult result) {
        VirtualizerFactory virtualizerFactory;
        if (result != null && (virtualizerFactory = this.getVirtualizerFactory()) != null) {
            virtualizerFactory.disposeReport((ReportResult)result);
        }
    }

    protected void setReadOnly(ReportUnitResult result) {
        VirtualizerFactory virtualizerFactory;
        if (result != null && (virtualizerFactory = this.getVirtualizerFactory()) != null) {
            virtualizerFactory.setReadOnly((ReportResult)result);
        }
    }

    protected ReportUnitResult executeReport(Boolean ignorePagination) {
        ReportUnitResult result = null;
        try {
            Map parametersMap = this.collectReportParameters();
            Map reportJobProperties = this.collectReportJobProperties();
            if (ignorePagination != null) {
                parametersMap.put("IS_IGNORE_PAGINATION", ignorePagination);
            }
            ReportUnitRequest request = new ReportUnitRequest(this.getReportUnitURI(), parametersMap, reportJobProperties);
            request.setJasperReportsContext(this.getJasperReportsContext());
            result = this.runReport(request);
        }
        catch (Exception e) {
            this.handleException(this.getMessage("report.scheduling.error.filling.report", null), e);
        }
        return result;
    }

    protected JasperReportsContext getJasperReportsContext() {
        String contextBeanName = this.schedulerContext.getString(SCHEDULER_CONTEXT_KEY_JASPERREPORTS_CONTEXT_BEAN);
        return (JasperReportsContext)this.applicationContext.getBean(contextBeanName, JasperReportsContext.class);
    }

    protected ReportUnitResult runReport(ReportUnitRequest request) {
        boolean firstRun = false;
        boolean recordingSnapshot = false;
        boolean useSnapshot = false;
        if (this.reportContext == null) {
            firstRun = true;
            this.reportContext = new SimpleReportContext();
            recordingSnapshot = this.recordDataSnapshot;
        } else {
            useSnapshot = this.recordedDataSnapshot;
        }
        request.getReportParameters().put("REPORT_CONTEXT", this.reportContext);
        request.setReportContext(this.reportContext);
        request.setRecordDataSnapshot(recordingSnapshot);
        request.setUseDataSnapshot(useSnapshot);
        EngineService engineService = this.getEngineService();
        ReportUnitResult result = (ReportUnitResult)engineService.execute(this.executionContext, (Request)request);
        this.setReadOnly(result);
        if (firstRun && this.getDataSnapshotService().isSnapshotPersistenceEnabled()) {
            this.dataSnapshotRecorded();
        }
        return result;
    }

    protected void dataSnapshotRecorded() {
        DataCacheProvider dataCacheProvider = this.getDataCacheProvider();
        DataCacheSnapshot dataSnapshot = dataCacheProvider.getDataSnapshot(this.executionContext, this.reportContext);
        if (dataSnapshot != null) {
            this.recordedDataSnapshot = true;
        }
        this.updateDataSnapshot(dataSnapshot);
        if (this.hasDataSnapshotOutput) {
            this.saveDataSnapshotOutput(dataSnapshot);
        }
    }

    protected void updateDataSnapshot(DataCacheSnapshot dataSnapshot) {
        block8: {
            DataSnapshotService snapshotService = this.getDataSnapshotService();
            if (!snapshotService.isSnapshotPersistenceEnabled()) {
                return;
            }
            if (dataSnapshot == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("failed to record data snapshot for job " + this.jobDetails.getId()));
                }
                return;
            }
            if (!dataSnapshot.getSnapshot().isPersistable()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("data snapshot for job " + this.jobDetails.getId() + " is not persistable"));
                }
                return;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("updating report with data snapshot at " + this.reportUnit.getURIString()));
                }
                snapshotService.saveReportDataSnapshot(this.executionContext, this.reportContext, this.reportUnit);
                this.reportUnit = (ReportUnit)this.getRepository().getResource(this.executionContext, this.reportUnit.getURIString(), ReportUnit.class);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block8;
                log.warn((Object)("Failed to update data snapshot for report " + this.reportUnit.getURIString()), (Throwable)e);
            }
        }
    }

    protected void saveDataSnapshotOutput(DataCacheSnapshot dataSnapshot) {
        try {
            DataSnapshotService snapshotService = this.getDataSnapshotService();
            if (!snapshotService.isSnapshotPersistenceEnabled()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("data snapshot persistence disabled for " + this.jobDetails.getId()));
                }
                throw new JSException("report.scheduling.error.saving.data.snapshot.disabled");
            }
            if (dataSnapshot == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("failed to record data snapshot for job " + this.jobDetails.getId()));
                }
                throw new JSException("report.scheduling.error.data.snapshot.not.populated");
            }
            if (!dataSnapshot.getSnapshot().isPersistable()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("data snapshot for job " + this.jobDetails.getId() + " is not persistable"));
                }
                throw new JSException("report.scheduling.error.data.snapshot.not.persistable");
            }
            String destinationFolderURI = this.jobDetails.getContentRepositoryDestination().getFolderURI();
            if (!destinationFolderURI.equals(this.reportUnit.getParentPath()) || !this.dataSnapshotOutputName.equals(this.reportUnit.getName())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("saving report with data snapshot at " + destinationFolderURI + "/" + this.dataSnapshotOutputName));
                }
                String savedURI = snapshotService.saveReportDataSnapshotCopy(this.executionContext, this.reportContext, this.reportUnit, destinationFolderURI, this.dataSnapshotOutputName, this.jobDetails.getContentRepositoryDestination().isOverwriteFiles());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("saved report copy at " + savedURI));
                }
            }
        }
        catch (Exception e) {
            this.handleException(this.getMessage("report.scheduling.error.saving.data.snapshot.failed", null), e);
        }
    }

    protected DataSnapshotService getDataSnapshotService() {
        String serviceBeanName = this.schedulerContext.getString(SCHEDULER_CONTEXT_KEY_DATA_SNAPSHOT_SERVICE_BEAN);
        return (DataSnapshotService)this.applicationContext.getBean(serviceBeanName, DataSnapshotService.class);
    }

    protected DataCacheProvider getDataCacheProvider() {
        String serviceBeanName = this.schedulerContext.getString(SCHEDULER_CONTEXT_KEY_DATA_CACHE_PROVIDER_BEAN);
        return (DataCacheProvider)this.applicationContext.getBean(serviceBeanName, DataCacheProvider.class);
    }

    public boolean cancelExecution() {
        this.cancelRequested = true;
        return true;
    }

    private boolean isCancelRequested() throws CancelRequestException {
        if (this.cancelRequested) {
            throw new CancelRequestException();
        }
        return false;
    }

    protected Map collectReportParameters() {
        HashMap params = new HashMap();
        Map jobParams = this.jobDetails.getSource().getParametersMap();
        if (jobParams != null) {
            params.putAll(jobParams);
        }
        this.putAdditionalParameters(params);
        return params;
    }

    protected Map collectReportJobProperties() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map jobParams = this.jobDetails.getSource().getParametersMap();
        if (jobParams != null) {
            params.putAll(jobParams);
        }
        params.put(EngineServiceImpl.ReportExecutionStatus.PROPERTY_JOBID, this.jobDetails.getId());
        params.put(EngineServiceImpl.ReportExecutionStatus.PROPERTY_JOBLABEL, this.jobDetails.getLabel());
        params.put(EngineServiceImpl.ReportExecutionStatus.PROPERTY_REPORTURI, this.jobDetails.getSource().getReportUnitURI());
        Date scheduledFireTime = this.jobContext.getScheduledFireTime();
        params.put(EngineServiceImpl.ReportExecutionStatus.PROPERTY_FIRETIME, scheduledFireTime);
        params.put(EngineServiceImpl.ReportExecutionStatus.PROPERTY_USERNAME, this.jobDetails.getUsername());
        params.put(EngineServiceImpl.ReportExecutionStatus.PROPERTY_QUARTZJOB, this);
        return params;
    }

    protected void putAdditionalParameters(Map parametersMap) {
        VirtualizerFactory virtualizerFactory;
        if (!parametersMap.containsKey(REPORT_PARAMETER_SCHEDULED_TIME)) {
            Date scheduledFireTime = this.jobContext.getScheduledFireTime();
            parametersMap.put(REPORT_PARAMETER_SCHEDULED_TIME, scheduledFireTime);
        }
        if ((virtualizerFactory = this.getVirtualizerFactory()) != null) {
            parametersMap.put("REPORT_VIRTUALIZER", virtualizerFactory.getVirtualizer());
        }
    }

    protected List<Output> createOutputs() throws JobExecutionException {
        Set outputFormats = this.jobDetails.getOutputFormats();
        ArrayList<Output> outputs = new ArrayList<Output>(outputFormats.size());
        for (Byte format : outputFormats) {
            Output output = null;
            try {
                output = this.getOutput(format, this.getBaseFileName());
                if (output == null) continue;
                outputs.add(output);
            }
            catch (Exception e) {
                String formatKey = this.getMessage("report.scheduling.output.format." + format, null);
                String formatLabel = this.getMessage("report.output." + formatKey + ".label", null);
                this.handleException(this.getMessage("report.scheduling.error.exporting.report", new Object[]{formatLabel}), e);
            }
        }
        return outputs;
    }

    protected String getBaseFileName() {
        String baseFilename = this.jobDetails.getBaseOutputFilename();
        if (this.jobDetails.getContentRepositoryDestination().isSequentialFilenames()) {
            Date scheduledTime = this.jobContext.getScheduledFireTime();
            SimpleDateFormat format = this.getTimestampFormat();
            baseFilename = this.jobDetails.getBaseOutputFilename() + REPOSITORY_FILENAME_SEQUENCE_SEPARATOR + format.format(scheduledTime);
        } else {
            baseFilename = this.jobDetails.getBaseOutputFilename();
        }
        return baseFilename;
    }

    protected SimpleDateFormat getTimestampFormat() {
        String pattern = this.jobDetails.getContentRepositoryDestination().getTimestampPattern();
        if (pattern == null || pattern.length() == 0) {
            pattern = REPOSITORY_FILENAME_TIMESTAMP_SEQUENCE_PATTERN;
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern, this.getLocale());
        return format;
    }

    protected boolean isEmpty(ReportUnitResult result) {
        JRPrintPage page;
        List elements;
        if (result == null) {
            return false;
        }
        JasperPrint jasperPrint = result.getJasperPrint();
        List pages = jasperPrint.getPages();
        boolean empty = pages == null || pages.isEmpty() ? true : (pages.size() == 1 ? (elements = (page = (JRPrintPage)pages.get(0)).getElements()) == null || elements.isEmpty() : false);
        return empty;
    }

    protected Output getOutput(Byte format, String baseFilename) throws JobExecutionException {
        if (format == null) {
            throw new JSException("jsexception.report.unknown.output.format", new Object[]{"null"});
        }
        if (format == 100) {
            this.hasDataSnapshotOutput = true;
            this.dataSnapshotOutputName = baseFilename;
            return null;
        }
        String fileExtension = (String)this.getOutputKeyMapping().get(format.toString());
        if (fileExtension == null) {
            throw new JSException("jsexception.report.unknown.output.format", new Object[]{new Byte(format)});
        }
        return (Output)this.getOutputFormatMap().get(fileExtension);
    }

    protected String getReportUnitURI() {
        return this.jobDetails.getSource().getReportUnitURI();
    }

    protected JRHyperlinkProducerFactory getHyperlinkProducerFactory() {
        JRHyperlinkProducerFactory engineService = (JRHyperlinkProducerFactory)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_HYPERLINK_PRODUCER_FACTORY);
        return engineService;
    }

    protected RepositoryService getRepository() {
        RepositoryService repositoryService = (RepositoryService)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_REPOSITORY);
        return repositoryService;
    }

    protected void sendMailNotification(List reportOutputs) throws JobExecutionException {
        ReportJobMailNotification mailNotification = this.jobDetails.getMailNotification();
        if (mailNotification == null) {
            return;
        }
        this.getReportExecutionJobMailNotification().sendMailNotification(this, this.jobDetails, reportOutputs);
    }

    protected String getRepositoryLinkDescription() {
        return this.reportUnit.getLabel();
    }

    protected ContentResourceURIResolver getContentResourceURIResolver() {
        return (ContentResourceURIResolver)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_CONTENT_RESOURCE_URI_RESOLVER);
    }

    protected LockManager getLockManager() {
        return (LockManager)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_LOCK_MANAGER);
    }

    protected String getCharacterEncoding() {
        CharacterEncodingProvider encodingProvider = (CharacterEncodingProvider)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_ENCODING_PROVIDER);
        return encodingProvider.getCharacterEncoding();
    }

    protected String[] getAlertMailRecipients(ReportJobAlert alert) {
        String adminRoleName = this.getAdministratorRole();
        ArrayList<String> toAddresses = new ArrayList<String>();
        if (alert.getToAddresses() != null && !alert.getToAddresses().isEmpty()) {
            for (String address : alert.getToAddresses()) {
                toAddresses.add(address);
            }
        }
        User user = this.getSecurityContextProvider().getUserAuthorityService().getUser(this.executionContext, this.username);
        switch (alert.getRecipient()) {
            case ADMIN: {
                List userList = this.getSecurityContextProvider().getUserAuthorityService().getUsersInRole(this.executionContext, adminRoleName);
                if (userList == null) break;
                for (Object user1 : userList) {
                    if (((User)user1).getEmailAddress() == null || !this.fromSameOrganization(user, (User)user1)) continue;
                    toAddresses.add(((User)user1).getEmailAddress());
                }
                break;
            }
            case OWNER: {
                if (user == null || user.getEmailAddress() == null) break;
                toAddresses.add(user.getEmailAddress());
                break;
            }
            case OWNER_AND_ADMIN: {
                List userList = this.getSecurityContextProvider().getUserAuthorityService().getUsersInRole(this.executionContext, adminRoleName);
                if (userList != null) {
                    for (Object user1 : userList) {
                        if (((User)user1).getEmailAddress() == null || !this.fromSameOrganization(user, (User)user1)) continue;
                        toAddresses.add(((User)user1).getEmailAddress());
                    }
                }
                if (user == null || user.getEmailAddress() == null) break;
                toAddresses.add(user.getEmailAddress());
                break;
            }
        }
        if (toAddresses != null && !toAddresses.isEmpty()) {
            String[] addressArray = new String[toAddresses.size()];
            toAddresses.toArray(addressArray);
            return addressArray;
        }
        return null;
    }

    protected boolean fromSameOrganization(User user1, User user2) {
        return true;
    }

    protected String getFromAddress() {
        String fromAddress = (String)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_MAIL_FROM_ADDRESS);
        return fromAddress;
    }

    protected JavaMailSender getMailSender() {
        JavaMailSender mailSender = (JavaMailSender)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_MAIL_SENDER);
        return mailSender;
    }

    protected Map getExportParametersMap() {
        return (Map)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_EXPORT_PARAMETRES_MAP);
    }

    protected String getAdministratorRole() {
        String administratorRole = (String)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_ADMINISTRATOR_ROLE);
        return administratorRole;
    }

    protected ReportExecutionJobInit getReportExecutionJobInit() {
        ReportExecutionJobInit initJob = (ReportExecutionJobInit)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_REPORT_EXECUTION_JOB_INIT);
        return initJob;
    }

    protected ReportExecutionJobAlert getReportExecutionJobAlert() {
        ReportExecutionJobAlert alert = (ReportExecutionJobAlert)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_REPORT_EXECUTION_JOB_ALERT);
        return alert;
    }

    protected ReportExecutionJobMailNotification getReportExecutionJobMailNotification() {
        ReportExecutionJobMailNotification mailNotification = (ReportExecutionJobMailNotification)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_REPORT_EXECUTION_JOB_MAIL_NOTIFICATION);
        return mailNotification;
    }

    protected ReportExecutionJobFileSaving getReportExecutionJobFileSaving() {
        ReportExecutionJobFileSaving savingFile = (ReportExecutionJobFileSaving)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_REPORT_EXECUTION_JOB_FILE_SAVING);
        return savingFile;
    }

    protected boolean isAutoDeleteBrokenUriReportJob() {
        String value = (String)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_AUTO_DELETE_BROKEN_URI_REPORT_JOB);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true");
    }

    protected Map getOutputFormatMap() {
        return (Map)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_OUTPUT_FORMAT_MAP);
    }

    protected Map getOutputKeyMapping() {
        return (Map)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_OUTPUT_KEY_MAPPING);
    }

    protected DataContainer createDataContainer(Output output) {
        DataContainer dataContainer = this.createDataContainer();
        if (output.isCompress()) {
            dataContainer = DataContainerStreamUtil.createCompressedContainer((DataContainer)dataContainer);
        }
        return dataContainer;
    }

    protected DataContainer createDataContainer() {
        DataContainerFactory factory = (DataContainerFactory)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_DATA_CONTAINER_FACTORY);
        DataContainer dataContainer = factory.createDataContainer();
        this.dataContainers.put(dataContainer, Boolean.TRUE);
        return dataContainer;
    }

    protected class CancelRequestException
    extends JSException {
        public CancelRequestException() {
            super("report.scheduling.cancel.requested.by.user");
        }
    }
}

