/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.teiid.common.buffer.impl.BlockManager;
import org.teiid.common.buffer.impl.ExtensibleBufferedOutputStream;

final class BlockOutputStream
extends ExtensibleBufferedOutputStream {
    private final BlockManager blockManager;
    int blockNum = -1;
    private final int maxBlocks;
    private final boolean allocate;
    static final IOException exceededMax = new IOException();

    BlockOutputStream(BlockManager blockManager, int maxBlocks) {
        this.blockManager = blockManager;
        this.allocate = maxBlocks != -1;
        this.maxBlocks = maxBlocks - 2;
    }

    @Override
    protected ByteBuffer newBuffer() throws IOException {
        if (!this.allocate) {
            return this.blockManager.getBlock(++this.blockNum);
        }
        if (this.blockNum > this.maxBlocks) {
            throw exceededMax;
        }
        return this.blockManager.allocateBlock(++this.blockNum);
    }

    @Override
    protected int flushDirect(int i) throws IOException {
        return i;
    }
}

