/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.impl.ConcurrentBitSet;
import org.teiid.common.buffer.impl.PhysicalInfo;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;

class BlockStore {
    final long blockSize;
    final ConcurrentBitSet blocksInUse;
    final FileStore[] stores;
    final ReentrantReadWriteLock[] locks;

    public BlockStore(StorageManager storageManager, int blockSize, int blockCountLog, int concurrencyLevel) {
        this.blockSize = blockSize;
        int blockCount = 1 << blockCountLog;
        this.blocksInUse = new ConcurrentBitSet(blockCount, concurrencyLevel);
        this.blocksInUse.setCompact(true);
        this.stores = new FileStore[concurrencyLevel];
        this.locks = new ReentrantReadWriteLock[concurrencyLevel];
        for (int i = 0; i < this.stores.length; ++i) {
            this.stores[i] = storageManager.createFileStore(String.valueOf(blockSize) + '_' + i);
            this.locks[i] = new ReentrantReadWriteLock();
        }
    }

    int getAndSetNextClearBit(PhysicalInfo info) {
        int result = this.blocksInUse.getAndSetNextClearBit();
        if (result == -1) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30059, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30059, new Object[]{this.blockSize}));
        }
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Allocating storage data block", result, "of size", this.blockSize, "to", info});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int writeToStorageBlock(PhysicalInfo info, InputStream is) throws IOException {
        int block = this.getAndSetNextClearBit(info);
        int segment = block / this.blocksInUse.getBitsPerSegment();
        boolean success = false;
        this.locks[segment].writeLock().lock();
        try {
            FileStore fs = this.stores[segment];
            long blockOffset = (long)(block % this.blocksInUse.getBitsPerSegment()) * this.blockSize;
            byte[] b = new byte[8192];
            int read = 0;
            while ((read = is.read(b, 0, b.length)) != -1) {
                fs.write(blockOffset, b, 0, read);
                blockOffset += (long)read;
            }
            success = true;
        }
        finally {
            this.locks[segment].writeLock().unlock();
            if (!success) {
                this.blocksInUse.clear(block);
                block = -1;
            }
        }
        return block;
    }
}

