/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.teiid.common.buffer.BaseCacheEntry;
import org.teiid.common.buffer.CacheKey;

public class LrfuEvictionQueue<V extends BaseCacheEntry> {
    private static final long DEFAULT_HALF_LIFE = 131072L;
    private static final long MIN_INTERVAL = 1024L;
    protected NavigableMap<CacheKey, V> evictionQueue = new ConcurrentSkipListMap<CacheKey, V>();
    protected AtomicLong clock;
    protected long maxInterval;
    protected long halfLife;

    public LrfuEvictionQueue(AtomicLong clock) {
        this.clock = clock;
        this.setHalfLife(131072L);
    }

    public boolean remove(V value) {
        return this.evictionQueue.remove(((BaseCacheEntry)value).getKey()) != null;
    }

    public boolean add(V value) {
        return this.evictionQueue.put(((BaseCacheEntry)value).getKey(), value) == null;
    }

    public void touch(V value) {
        long tick = this.clock.get();
        if (tick - 1024L < ((BaseCacheEntry)value).getKey().getLastAccess()) {
            return;
        }
        this.evictionQueue.remove(((BaseCacheEntry)value).getKey());
        this.recordAccess(value);
        this.evictionQueue.put(((BaseCacheEntry)value).getKey(), value);
    }

    public Collection<V> getEvictionQueue() {
        return this.evictionQueue.values();
    }

    public V firstEntry(boolean poll) {
        Map.Entry<CacheKey, V> entry = null;
        entry = poll ? this.evictionQueue.pollFirstEntry() : this.evictionQueue.firstEntry();
        if (entry != null) {
            return (V)((BaseCacheEntry)entry.getValue());
        }
        return null;
    }

    public void recordAccess(V value) {
        CacheKey key = ((BaseCacheEntry)value).getKey();
        long lastAccess = key.getLastAccess();
        long currentClock = this.clock.get();
        long orderingValue = key.getOrderingValue();
        orderingValue = this.computeNextOrderingValue(currentClock, lastAccess, orderingValue);
        ((BaseCacheEntry)value).setKey(new CacheKey(key.getId(), currentClock, orderingValue));
    }

    long computeNextOrderingValue(long currentTime, long lastAccess, long orderingValue) {
        long delta = currentTime - lastAccess;
        if (delta > this.maxInterval) {
            return currentTime;
        }
        long increase = Math.min(orderingValue, currentTime);
        increase >>= 1;
        increase = (long)((double)increase * ((double)orderingValue / (double)lastAccess));
        if (delta > this.halfLife) {
            while ((delta -= this.halfLife) > this.halfLife && (increase >>= 1) > 0L) {
            }
        }
        if (delta > 0L && increase > 0L) {
            increase = (long)((double)increase * ((double)this.halfLife / ((double)this.halfLife + (double)delta)));
        }
        return currentTime + increase;
    }

    public void setHalfLife(long halfLife) {
        this.halfLife = halfLife;
        this.maxInterval = 62L * this.halfLife;
    }
}

