/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.RegisterRequestParameter;
import org.teiid.query.processor.relational.LimitNode;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;

public class AccessNode
extends SubqueryAwareRelationalNode {
    private static final Object[] NO_PROJECTION = new Object[0];
    private static final int MAX_CONCURRENT = 10;
    private Command command;
    private String modelName;
    private String connectorBindingId;
    private boolean shouldEvaluate = false;
    private ArrayList<TupleSource> tupleSources = new ArrayList();
    private boolean isUpdate = false;
    private boolean returnedRows = false;
    protected Command nextCommand;
    private int reserved;
    private int schemaSize;
    private Object[] projection;
    private List<Expression> originalSelect;
    private Object modelId;
    public RegisterRequestParameter.SharedAccessInfo info;

    protected AccessNode() {
    }

    public AccessNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        this.schemaSize = this.getBufferManager().getSchemaSize(this.getOutputElements());
    }

    @Override
    public void reset() {
        super.reset();
        this.tupleSources.clear();
        this.isUpdate = false;
        this.returnedRows = false;
        this.nextCommand = null;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setModelId(Object id) {
        this.modelId = id;
    }

    public Object getModelId() {
        return this.modelId;
    }

    public void setModelName(String name) {
        this.modelName = name;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setShouldEvaluateExpressions(boolean shouldEvaluate) {
        this.shouldEvaluate = shouldEvaluate;
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        Command atomicCommand = this.command;
        boolean needProcessing = true;
        if (this.shouldEvaluate) {
            atomicCommand = this.initialCommand();
        }
        do {
            atomicCommand = this.nextCommand();
            if (this.shouldEvaluate) {
                needProcessing = this.prepareNextCommand(atomicCommand);
                this.nextCommand = null;
            } else {
                needProcessing = RelationalNodeUtil.shouldExecute(atomicCommand, true);
            }
            this.isUpdate = RelationalNodeUtil.isUpdate(atomicCommand);
            if (!needProcessing) continue;
            this.registerRequest(atomicCommand);
        } while (!this.processCommandsIndividually() && this.hasNextCommand() && this.tupleSources.size() < Math.min(10, this.getContext().getUserRequestSourceConcurrency()));
    }

    public boolean isShouldEvaluate() {
        return this.shouldEvaluate;
    }

    public void minimizeProject(Command atomicCommand) {
        if (!(atomicCommand instanceof Query)) {
            return;
        }
        Query query = (Query)atomicCommand;
        Select select = query.getSelect();
        List<Expression> symbols = select.getSymbols();
        if (symbols.size() == 1) {
            return;
        }
        boolean shouldProject = false;
        LinkedHashMap<Expression, Integer> uniqueSymbols = new LinkedHashMap<Expression, Integer>();
        this.projection = new Object[symbols.size()];
        this.originalSelect = new ArrayList<Expression>(query.getSelect().getSymbols());
        int i = 0;
        int j = 0;
        Iterator<Expression> iter = symbols.iterator();
        while (iter.hasNext()) {
            Expression ss = iter.next();
            Expression ex = SymbolMap.getExpression(ss);
            if (ex instanceof Constant) {
                this.projection[i] = ex;
                if (iter.hasNext() || j != 0) {
                    iter.remove();
                    shouldProject = true;
                } else {
                    this.projection[i] = j++;
                }
            } else {
                Integer index = (Integer)uniqueSymbols.get(ex);
                if (index == null) {
                    uniqueSymbols.put(ex, j);
                    index = j++;
                } else {
                    iter.remove();
                    shouldProject = true;
                }
                this.projection[i] = index;
            }
            ++i;
        }
        if (!shouldProject) {
            this.projection = NO_PROJECTION;
        } else if (query.getOrderBy() != null) {
            for (OrderByItem item : query.getOrderBy().getOrderByItems()) {
                Integer index = (Integer)uniqueSymbols.get(SymbolMap.getExpression(item.getSymbol()));
                if (index == null) continue;
                item.setExpressionPosition(index);
                item.setSymbol(select.getSymbols().get(index));
            }
        }
    }

    public List<Expression> getOriginalSelect() {
        return this.originalSelect;
    }

    public Object[] getProjection() {
        return this.projection;
    }

    static void rewriteAndEvaluate(Command atomicCommand, Evaluator eval, CommandContext context, QueryMetadataInterface metadata) throws TeiidProcessingException, TeiidComponentException {
        try {
            QueryRewriter.evaluateAndRewrite(atomicCommand, eval, context, metadata);
        }
        catch (QueryValidatorException e) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30174, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30174, new Object[]{atomicCommand}));
        }
    }

    protected Command initialCommand() throws TeiidProcessingException, TeiidComponentException {
        return this.nextCommand();
    }

    protected Command nextCommand() {
        if (this.nextCommand == null) {
            this.nextCommand = (Command)this.command.clone();
        }
        return this.nextCommand;
    }

    protected boolean prepareNextCommand(Command atomicCommand) throws TeiidComponentException, TeiidProcessingException {
        AccessNode.rewriteAndEvaluate(atomicCommand, this.getEvaluator(Collections.emptyMap()), this.getContext(), this.getContext().getMetadata());
        return RelationalNodeUtil.shouldExecute(atomicCommand, true);
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        while (!this.tupleSources.isEmpty() || this.hasNextCommand()) {
            if (this.tupleSources.isEmpty() && this.processCommandsIndividually()) {
                this.registerNext();
            }
            for (int i = 0; i < this.tupleSources.size(); ++i) {
                TupleSource tupleSource = this.tupleSources.get(i);
                try {
                    List<?> tuple = null;
                    while ((tuple = tupleSource.nextTuple()) != null) {
                        this.returnedRows = true;
                        if (this.projection != null && this.projection.length > 0) {
                            ArrayList newTuple = new ArrayList(this.projection.length);
                            for (Object object : this.projection) {
                                if (object instanceof Integer) {
                                    newTuple.add(tuple.get((Integer)object));
                                    continue;
                                }
                                newTuple.add(((Constant)object).getValue());
                            }
                            tuple = newTuple;
                        }
                        this.addBatchRow(tuple);
                        if (!this.isBatchFull()) continue;
                        return this.pullBatch();
                    }
                    tupleSource.closeSource();
                    this.tupleSources.remove(i--);
                    if (this.reserved > 0) {
                        this.reserved -= this.schemaSize;
                        this.getBufferManager().releaseBuffers(this.schemaSize);
                    }
                    if (this.processCommandsIndividually()) continue;
                    this.registerNext();
                    continue;
                }
                catch (BlockedException e) {
                    if (!this.processCommandsIndividually()) continue;
                    throw e;
                }
            }
            if (this.processCommandsIndividually()) {
                if (!this.hasPendingRows()) continue;
                return this.pullBatch();
            }
            if (this.tupleSources.isEmpty()) continue;
            throw BlockedException.block(this.getContext().getRequestId(), "Blocking on source request(s).");
        }
        if (this.isUpdate && !this.returnedRows) {
            ArrayList<Integer> tuple = new ArrayList<Integer>(1);
            tuple.add(0);
            this.addBatchRow(tuple);
        }
        this.terminateBatches();
        return this.pullBatch();
    }

    @Override
    protected void addBatchRow(List<?> row) {
        if (this.getOutputElements().isEmpty()) {
            row = Collections.emptyList();
        }
        super.addBatchRow(row);
    }

    private void registerNext() throws TeiidComponentException, TeiidProcessingException {
        while (this.hasNextCommand()) {
            Command atomicCommand = this.nextCommand();
            if (this.prepareNextCommand(atomicCommand)) {
                this.nextCommand = null;
                this.registerRequest(atomicCommand);
                break;
            }
            this.nextCommand = null;
        }
    }

    private void registerRequest(Command atomicCommand) throws TeiidComponentException, TeiidProcessingException {
        LimitNode parent;
        if (this.shouldEvaluate) {
            this.projection = null;
            this.minimizeProject(atomicCommand);
        }
        int limit = -1;
        if (this.getParent() instanceof LimitNode && (parent = (LimitNode)this.getParent()).getLimit() > 0) {
            limit = parent.getLimit() + parent.getOffset();
        }
        RegisterRequestParameter param = new RegisterRequestParameter(this.connectorBindingId, this.getID(), limit);
        param.info = this.info;
        this.tupleSources.add(this.getDataManager().registerRequest(this.getContext(), atomicCommand, this.modelName, param));
        if (this.tupleSources.size() > 1) {
            this.reserved += this.getBufferManager().reserveBuffers(this.schemaSize, BufferManager.BufferReserveMode.FORCE);
        }
    }

    protected boolean processCommandsIndividually() {
        return false;
    }

    protected boolean hasNextCommand() {
        return false;
    }

    @Override
    public void closeDirect() {
        this.getBufferManager().releaseBuffers(this.reserved);
        this.reserved = 0;
        super.closeDirect();
        this.closeSources();
    }

    private void closeSources() {
        for (TupleSource ts : this.tupleSources) {
            ts.closeSource();
        }
        this.tupleSources.clear();
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.command);
        if (this.info != null) {
            str.append(" [SHARED ").append(this.info.id).append("]");
        }
    }

    @Override
    public Object clone() {
        AccessNode clonedNode = new AccessNode();
        this.copyTo(clonedNode);
        return clonedNode;
    }

    protected void copyTo(AccessNode target) {
        super.copyTo(target);
        target.modelName = this.modelName;
        target.modelId = this.modelId;
        target.connectorBindingId = this.connectorBindingId;
        target.shouldEvaluate = this.shouldEvaluate;
        if (!this.shouldEvaluate) {
            target.projection = this.projection;
            target.originalSelect = this.originalSelect;
        }
        target.command = this.command;
        target.info = this.info;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        props.addProperty("Query", this.command.toString());
        props.addProperty("Model Name", this.modelName);
        if (this.projection != null && this.projection.length > 0 && this.originalSelect != null) {
            props.addProperty("Select Columns", this.originalSelect.toString());
        }
        props.addProperty("Model Name", this.modelName);
        if (this.info != null) {
            props.addProperty("Sharing ID", String.valueOf(this.info.id));
        }
        return props;
    }

    public String getConnectorBindingId() {
        return this.connectorBindingId;
    }

    public void setConnectorBindingId(String connectorBindingId) {
        this.connectorBindingId = connectorBindingId;
    }

    @Override
    protected Collection<? extends LanguageObject> getObjects() {
        ArrayList list = new ArrayList();
        if (this.shouldEvaluate) {
            for (SubqueryContainer<?> container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(this.command)) {
                if (container instanceof ExistsCriteria && ((ExistsCriteria)container).shouldEvaluate()) {
                    list.add(container);
                }
                if (!(container instanceof ScalarSubquery) || !((ScalarSubquery)container).shouldEvaluate()) continue;
                list.add(container);
            }
        }
        return list;
    }

    @Override
    public Boolean requiresTransaction(boolean transactionalReads) {
        Boolean required = super.requiresTransaction(transactionalReads);
        if (Boolean.TRUE.equals(required) || this.command instanceof StoredProcedure && ((StoredProcedure)this.command).getUpdateCount() > 1) {
            return true;
        }
        return null;
    }
}

