#
# java-client-kubevirt
# Copyright (C) 2019 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global	package_version 0.4.0
%global	package_maven_version 0.4.0

%global	_java_jdk_home /usr/lib/jvm/java-11-openjdk

Summary:	Kubevirt java client (%{name}) for oVirt
Name:		java-client-kubevirt
Version:	0.4.0
Release:	1%{?release_suffix}%{?dist}
License:	LGPLv2+
URL:		http://www.ovirt.org
Source:		http://resources.ovirt.org/pub/ovirt-master-snapshot/src/%{name}/%{name}-%{package_version}.tar.gz
Group:		Development/Libraries

BuildArch:	noarch

BuildRequires:	gcc
BuildRequires:	java-11-openjdk-devel >= 11.0.4


BuildRequires:	javapackages-local
BuildRequires:	maven >= 3.5.0
BuildRequires:  maven-local
BuildRequires:	maven-shade-plugin
BuildRequires:	maven-source-plugin
BuildRequires:  maven-compiler-plugin
BuildRequires:  maven-profile
BuildRequires:  maven-plugin-registry

# All are provided by our fat jar
Provides:	mvn(io.kubernetes:client-java) = 6.0.1
Provides:	mvn(io.gsonfire:gson-fire) = 1.8.3
Provides:	mvn(javax.annotation:javax.annotation-api) = 1.3.2

%description
java client kubevirt

%package javadoc
Summary:	Java-docs for %{name}
Group:		Documentation

%description javadoc
This package contains the API documentation for %{name}.

%prep
%setup -q -n %{name}-%{package_version}
%if 0%{?rhel} > 7
# No need for maven-javadoc-plugin in RHEL 8, xmvn will take care of it.
%pom_remove_plugin -r :maven-javadoc-plugin pom.xml.in
%endif

%build
%configure MVN="xmvn"
# this step is necessary to resolve mvn dependencies that are not available
# as RPM distribution
make %{?_smp_mflags}

# necessary because jdk 1.8 comes as default with xmvn
export JAVA_HOME="%{_java_jdk_home}"

%mvn_build -i -- %{?_mvn_opts}
%mvn_artifact dependency-reduced-pom.xml target/java-client-kubevirt-%{version}.jar

%install
%mvn_install

%files -f .mfiles
%dir %{_javadir}/%{name}

%files javadoc -f .mfiles-javadoc

%changelog
* Thu Mar 19 2020 Piotr Kliczewski <pkliczew@redhat.com = 0.4.0
- Update kubevirt api definition

* Thu Feb 20 2020 Moti Asayag <masayag@redhat.com> - 0.3.0
- Add support for network attachment definitions

* Thu Jan 23 2020 Piotr Kliczewski <pkliczew@redhat.com> - 0.2.0
- use brew maven-build

* Mon Dec 2 2019 Piotr Kliczewski <pkliczew@redhat.com> - 0.1.0
- Initial changes
