/*
 * KubeVirt API
 * This is KubeVirt API an add-on for Kubernetes.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: kubevirt-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package kubevirt.io;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import kubevirt.io.V1CPU;
import kubevirt.io.V1Chassis;
import kubevirt.io.V1Clock;
import kubevirt.io.V1Devices;
import kubevirt.io.V1Features;
import kubevirt.io.V1Firmware;
import kubevirt.io.V1Machine;
import kubevirt.io.V1Memory;
import kubevirt.io.V1ResourceRequirements;

/**
 * V1DomainSpec
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-11-10T14:44:51.030+02:00")
public class V1DomainSpec {
  @SerializedName("chassis")
  private V1Chassis chassis = null;

  @SerializedName("clock")
  private V1Clock clock = null;

  @SerializedName("cpu")
  private V1CPU cpu = null;

  @SerializedName("devices")
  private V1Devices devices = null;

  @SerializedName("features")
  private V1Features features = null;

  @SerializedName("firmware")
  private V1Firmware firmware = null;

  @SerializedName("ioThreadsPolicy")
  private String ioThreadsPolicy = null;

  @SerializedName("machine")
  private V1Machine machine = null;

  @SerializedName("memory")
  private V1Memory memory = null;

  @SerializedName("resources")
  private V1ResourceRequirements resources = null;

  public V1DomainSpec chassis(V1Chassis chassis) {
    this.chassis = chassis;
    return this;
  }

   /**
   * Chassis specifies the chassis info passed to the domain. +optional
   * @return chassis
  **/
  @ApiModelProperty(value = "Chassis specifies the chassis info passed to the domain. +optional")
  public V1Chassis getChassis() {
    return chassis;
  }

  public void setChassis(V1Chassis chassis) {
    this.chassis = chassis;
  }

  public V1DomainSpec clock(V1Clock clock) {
    this.clock = clock;
    return this;
  }

   /**
   * Clock sets the clock and timers of the vmi. +optional
   * @return clock
  **/
  @ApiModelProperty(value = "Clock sets the clock and timers of the vmi. +optional")
  public V1Clock getClock() {
    return clock;
  }

  public void setClock(V1Clock clock) {
    this.clock = clock;
  }

  public V1DomainSpec cpu(V1CPU cpu) {
    this.cpu = cpu;
    return this;
  }

   /**
   * CPU allow specified the detailed CPU topology inside the vmi. +optional
   * @return cpu
  **/
  @ApiModelProperty(value = "CPU allow specified the detailed CPU topology inside the vmi. +optional")
  public V1CPU getCpu() {
    return cpu;
  }

  public void setCpu(V1CPU cpu) {
    this.cpu = cpu;
  }

  public V1DomainSpec devices(V1Devices devices) {
    this.devices = devices;
    return this;
  }

   /**
   * Devices allows adding disks, network interfaces, ...
   * @return devices
  **/
  @ApiModelProperty(required = true, value = "Devices allows adding disks, network interfaces, ...")
  public V1Devices getDevices() {
    return devices;
  }

  public void setDevices(V1Devices devices) {
    this.devices = devices;
  }

  public V1DomainSpec features(V1Features features) {
    this.features = features;
    return this;
  }

   /**
   * Features like acpi, apic, hyperv, smm. +optional
   * @return features
  **/
  @ApiModelProperty(value = "Features like acpi, apic, hyperv, smm. +optional")
  public V1Features getFeatures() {
    return features;
  }

  public void setFeatures(V1Features features) {
    this.features = features;
  }

  public V1DomainSpec firmware(V1Firmware firmware) {
    this.firmware = firmware;
    return this;
  }

   /**
   * Firmware. +optional
   * @return firmware
  **/
  @ApiModelProperty(value = "Firmware. +optional")
  public V1Firmware getFirmware() {
    return firmware;
  }

  public void setFirmware(V1Firmware firmware) {
    this.firmware = firmware;
  }

  public V1DomainSpec ioThreadsPolicy(String ioThreadsPolicy) {
    this.ioThreadsPolicy = ioThreadsPolicy;
    return this;
  }

   /**
   * Controls whether or not disks will share IOThreads. Omitting IOThreadsPolicy disables use of IOThreads. One of: shared, auto +optional
   * @return ioThreadsPolicy
  **/
  @ApiModelProperty(value = "Controls whether or not disks will share IOThreads. Omitting IOThreadsPolicy disables use of IOThreads. One of: shared, auto +optional")
  public String getIoThreadsPolicy() {
    return ioThreadsPolicy;
  }

  public void setIoThreadsPolicy(String ioThreadsPolicy) {
    this.ioThreadsPolicy = ioThreadsPolicy;
  }

  public V1DomainSpec machine(V1Machine machine) {
    this.machine = machine;
    return this;
  }

   /**
   * Machine type. +optional
   * @return machine
  **/
  @ApiModelProperty(value = "Machine type. +optional")
  public V1Machine getMachine() {
    return machine;
  }

  public void setMachine(V1Machine machine) {
    this.machine = machine;
  }

  public V1DomainSpec memory(V1Memory memory) {
    this.memory = memory;
    return this;
  }

   /**
   * Memory allow specifying the VMI memory features. +optional
   * @return memory
  **/
  @ApiModelProperty(value = "Memory allow specifying the VMI memory features. +optional")
  public V1Memory getMemory() {
    return memory;
  }

  public void setMemory(V1Memory memory) {
    this.memory = memory;
  }

  public V1DomainSpec resources(V1ResourceRequirements resources) {
    this.resources = resources;
    return this;
  }

   /**
   * Resources describes the Compute Resources required by this vmi.
   * @return resources
  **/
  @ApiModelProperty(value = "Resources describes the Compute Resources required by this vmi.")
  public V1ResourceRequirements getResources() {
    return resources;
  }

  public void setResources(V1ResourceRequirements resources) {
    this.resources = resources;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1DomainSpec v1DomainSpec = (V1DomainSpec) o;
    return Objects.equals(this.chassis, v1DomainSpec.chassis) &&
        Objects.equals(this.clock, v1DomainSpec.clock) &&
        Objects.equals(this.cpu, v1DomainSpec.cpu) &&
        Objects.equals(this.devices, v1DomainSpec.devices) &&
        Objects.equals(this.features, v1DomainSpec.features) &&
        Objects.equals(this.firmware, v1DomainSpec.firmware) &&
        Objects.equals(this.ioThreadsPolicy, v1DomainSpec.ioThreadsPolicy) &&
        Objects.equals(this.machine, v1DomainSpec.machine) &&
        Objects.equals(this.memory, v1DomainSpec.memory) &&
        Objects.equals(this.resources, v1DomainSpec.resources);
  }

  @Override
  public int hashCode() {
    return Objects.hash(chassis, clock, cpu, devices, features, firmware, ioThreadsPolicy, machine, memory, resources);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1DomainSpec {\n");
    
    sb.append("    chassis: ").append(toIndentedString(chassis)).append("\n");
    sb.append("    clock: ").append(toIndentedString(clock)).append("\n");
    sb.append("    cpu: ").append(toIndentedString(cpu)).append("\n");
    sb.append("    devices: ").append(toIndentedString(devices)).append("\n");
    sb.append("    features: ").append(toIndentedString(features)).append("\n");
    sb.append("    firmware: ").append(toIndentedString(firmware)).append("\n");
    sb.append("    ioThreadsPolicy: ").append(toIndentedString(ioThreadsPolicy)).append("\n");
    sb.append("    machine: ").append(toIndentedString(machine)).append("\n");
    sb.append("    memory: ").append(toIndentedString(memory)).append("\n");
    sb.append("    resources: ").append(toIndentedString(resources)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

