/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import java.math.BigInteger;
import java.util.List;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.GlusterHook;
import org.ovirt.engine.sdk4.types.GlusterHookStatus;
import org.ovirt.engine.sdk4.types.GlusterServerHook;
import org.ovirt.engine.sdk4.types.HookContentType;
import org.ovirt.engine.sdk4.types.HookStage;

public class GlusterHookContainer extends IdentifiedContainer implements GlusterHook {
    private String checksum;
    private BigInteger conflictStatus;
    private String conflicts;
    private String content;
    private HookContentType contentType;
    private String glusterCommand;
    private HookStage stage;
    private GlusterHookStatus status;
    private Cluster cluster;
    private List<GlusterServerHook> serverHooks;
    
    public String checksum() {
        return checksum;
    }
    
    public void checksum(String newChecksum) {
        checksum = newChecksum;
    }
    
    public boolean checksumPresent() {
        return checksum != null;
    }
    
    public BigInteger conflictStatus() {
        return conflictStatus;
    }
    
    public void conflictStatus(BigInteger newConflictStatus) {
        conflictStatus = newConflictStatus;
    }
    
    public boolean conflictStatusPresent() {
        return conflictStatus != null;
    }
    
    public String conflicts() {
        return conflicts;
    }
    
    public void conflicts(String newConflicts) {
        conflicts = newConflicts;
    }
    
    public boolean conflictsPresent() {
        return conflicts != null;
    }
    
    public String content() {
        return content;
    }
    
    public void content(String newContent) {
        content = newContent;
    }
    
    public boolean contentPresent() {
        return content != null;
    }
    
    public HookContentType contentType() {
        return contentType;
    }
    
    public void contentType(HookContentType newContentType) {
        contentType = newContentType;
    }
    
    public boolean contentTypePresent() {
        return contentType != null;
    }
    
    public String glusterCommand() {
        return glusterCommand;
    }
    
    public void glusterCommand(String newGlusterCommand) {
        glusterCommand = newGlusterCommand;
    }
    
    public boolean glusterCommandPresent() {
        return glusterCommand != null;
    }
    
    public HookStage stage() {
        return stage;
    }
    
    public void stage(HookStage newStage) {
        stage = newStage;
    }
    
    public boolean stagePresent() {
        return stage != null;
    }
    
    public GlusterHookStatus status() {
        return status;
    }
    
    public void status(GlusterHookStatus newStatus) {
        status = newStatus;
    }
    
    public boolean statusPresent() {
        return status != null;
    }
    
    public Cluster cluster() {
        return cluster;
    }
    
    public void cluster(Cluster newCluster) {
        cluster = newCluster;
    }
    
    public boolean clusterPresent() {
        return cluster != null;
    }
    
    public List<GlusterServerHook> serverHooks() {
        return makeUnmodifiableList(serverHooks);
    }
    
    public void serverHooks(List<GlusterServerHook> newServerHooks) {
        serverHooks = makeArrayList(newServerHooks);
    }
    
    public boolean serverHooksPresent() {
        return serverHooks != null && !serverHooks.isEmpty();
    }
    
}
