/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;
import java.util.List;

public interface User extends Identified {
    String department();
    
    boolean departmentPresent();
    
    String domainEntryId();
    
    boolean domainEntryIdPresent();
    
    String email();
    
    boolean emailPresent();
    
    String lastName();
    
    boolean lastNamePresent();
    
    boolean loggedIn();
    
    boolean loggedInPresent();
    
    String namespace();
    
    boolean namespacePresent();
    
    String password();
    
    boolean passwordPresent();
    
    String principal();
    
    boolean principalPresent();
    
    String userName();
    
    boolean userNamePresent();
    
    Domain domain();
    
    boolean domainPresent();
    
    List<Group> groups();
    
    boolean groupsPresent();
    
    List<Permission> permissions();
    
    boolean permissionsPresent();
    
    List<Role> roles();
    
    boolean rolesPresent();
    
    List<SshPublicKey> sshPublicKeys();
    
    boolean sshPublicKeysPresent();
    
    List<Tag> tags();
    
    boolean tagsPresent();
    
}
