/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import java.math.BigDecimal;
import org.ovirt.engine.sdk4.internal.containers.ValueContainer;
import org.ovirt.engine.sdk4.types.Value;

public class ValueBuilder {
    private BigDecimal datum;
    private String detail;
    
    public ValueBuilder datum(float newDatum) {
        datum = BigDecimal.valueOf((double) newDatum);
        return this;
    }
    
    public ValueBuilder datum(Float newDatum) {
        if (newDatum == null) {
            datum = null;
        }
        else {
            datum = BigDecimal.valueOf(newDatum.doubleValue());
        }
        return this;
    }
    
    public ValueBuilder datum(double newDatum) {
        datum = BigDecimal.valueOf(newDatum);
        return this;
    }
    
    public ValueBuilder datum(Double newDatum) {
        if (newDatum == null) {
            datum = null;
        }
        else {
            datum = BigDecimal.valueOf(newDatum.doubleValue());
        }
        return this;
    }
    
    public ValueBuilder datum(BigDecimal newDatum) {
        datum = newDatum;
        return this;
    }
    
    
    public ValueBuilder detail(String newDetail) {
        detail = newDetail;
        return this;
    }
    
    
    public Value build() {
        ValueContainer container = new ValueContainer();
        container.datum(datum);
        container.detail(detail);
        return container;
    }
}
