/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import org.ovirt.engine.sdk4.types.GlusterHookStatus;
import org.ovirt.engine.sdk4.types.GlusterServerHook;
import org.ovirt.engine.sdk4.types.HookContentType;
import org.ovirt.engine.sdk4.types.Host;

public class GlusterServerHookContainer extends IdentifiedContainer implements GlusterServerHook {
    private String checksum;
    private HookContentType contentType;
    private GlusterHookStatus status;
    private Host host;
    
    public String checksum() {
        return checksum;
    }
    
    public void checksum(String newChecksum) {
        checksum = newChecksum;
    }
    
    public boolean checksumPresent() {
        return checksum != null;
    }
    
    public HookContentType contentType() {
        return contentType;
    }
    
    public void contentType(HookContentType newContentType) {
        contentType = newContentType;
    }
    
    public boolean contentTypePresent() {
        return contentType != null;
    }
    
    public GlusterHookStatus status() {
        return status;
    }
    
    public void status(GlusterHookStatus newStatus) {
        status = newStatus;
    }
    
    public boolean statusPresent() {
        return status != null;
    }
    
    public Host host() {
        return host;
    }
    
    public void host(Host newHost) {
        host = newHost;
    }
    
    public boolean hostPresent() {
        return host != null;
    }
    
}
