/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.Version;

public class VersionContainer extends IdentifiedContainer implements Version {
    private BigInteger build;
    private String fullVersion;
    private BigInteger major;
    private BigInteger minor;
    private BigInteger revision;
    
    public BigInteger build() {
        return build;
    }
    
    public void build(BigInteger newBuild) {
        build = newBuild;
    }
    
    public boolean buildPresent() {
        return build != null;
    }
    
    public String fullVersion() {
        return fullVersion;
    }
    
    public void fullVersion(String newFullVersion) {
        fullVersion = newFullVersion;
    }
    
    public boolean fullVersionPresent() {
        return fullVersion != null;
    }
    
    public BigInteger major() {
        return major;
    }
    
    public void major(BigInteger newMajor) {
        major = newMajor;
    }
    
    public boolean majorPresent() {
        return major != null;
    }
    
    public BigInteger minor() {
        return minor;
    }
    
    public void minor(BigInteger newMinor) {
        minor = newMinor;
    }
    
    public boolean minorPresent() {
        return minor != null;
    }
    
    public BigInteger revision() {
        return revision;
    }
    
    public void revision(BigInteger newRevision) {
        revision = newRevision;
    }
    
    public boolean revisionPresent() {
        return revision != null;
    }
    
}
